/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.sql.test;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import javax.sql.DataSource;
import liquibase.ContextExpression;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.SetupException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.RowCountQuery;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.conf.RenderNameStyle;
import org.jooq.impl.DSL;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.PostgreSQLContainer;

public class SqlTestUtil {
    public static String tcJdbcUrl = "jdbc:tc:mysql:5.7.22:///somedb";
    public static String tcPgJdbcUrl = "jdbc:tc:postgres:10.13:///test";

    @Deprecated
    public static TestDatabase initDatabase() {
        return SqlTestUtil.initDatabase("jdbc:h2:mem:test;MODE=MYSQL");
    }

    @Deprecated
    public static TestDatabase initPreviousDatabase() {
        return SqlTestUtil.initDatabase("jdbc:h2:mem:test_previous;MODE=MYSQL");
    }

    public static TestDatabase initTcMysqlDatabase() {
        return SqlTestUtil.initDatabase(tcJdbcUrl, SQLDialect.MYSQL);
    }

    public static TestDatabase initTcPostgresDatabase() {
        PostgreSQLContainer container = new PostgreSQLContainer("postgres:10.13").withDatabaseName("test").withUsername("test").withPassword("test");
        container.start();
        String fullJDBCUrl = container.getJdbcUrl() + String.format("&user=%s&password=%s", container.getUsername(), container.getPassword());
        return SqlTestUtil.initDatabase(fullJDBCUrl, SQLDialect.POSTGRES, container.getDatabaseName());
    }

    @Deprecated
    public static TestDatabase initPreviousTcMysqlDatabase() {
        MySQLContainer container = new MySQLContainer("mysql:5.7.22").withDatabaseName("previous").withUsername("test").withPassword("test");
        container.start();
        String jdbcUrl = String.format("%s?user=%s&password=%s", container.getJdbcUrl(), container.getUsername(), container.getPassword());
        return SqlTestUtil.initDatabase(jdbcUrl, SQLDialect.MYSQL, "previous");
    }

    public static TestDatabase initDualTcMysqlDatabases() {
        return SqlTestUtil.initDualTcDatabases("mysql:5.7.34", SQLDialect.MYSQL);
    }

    public static TestDatabase initDualTcPostgresDatabases() {
        return SqlTestUtil.initDualTcDatabases("postgres:10.13", SQLDialect.POSTGRES);
    }

    private static TestDatabase initDualTcDatabases(String imageName, SQLDialect dialect) {
        String grantCommand;
        String rootUser;
        MySQLContainer container;
        switch (dialect) {
            case MYSQL: {
                container = new MySQLContainer(imageName);
                rootUser = "root";
                grantCommand = "grant all privileges on previous.* to 'test'@'%'";
                break;
            }
            case POSTGRES: {
                container = new PostgreSQLContainer(imageName);
                rootUser = "test";
                grantCommand = null;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported SQL dialect: " + dialect.getName());
            }
        }
        container = container.withDatabaseName("current").withUsername("test").withPassword("test");
        container.start();
        String queryStart = container.getJdbcUrl().contains("?") ? "&" : "?";
        String rootJdbcUrl = String.format("%s%suser=%s&password=%s", container.getJdbcUrl(), queryStart, rootUser, container.getPassword());
        try {
            Connection rootCon = DriverManager.getConnection(rootJdbcUrl);
            rootCon.createStatement().executeUpdate("create database previous");
            if (grantCommand != null) {
                rootCon.createStatement().executeUpdate(grantCommand);
            }
            rootCon.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error setting up testcontainer database", e);
        }
        String currentJdbcUrl = String.format("%s%suser=%s&password=%s", container.getJdbcUrl(), queryStart, container.getUsername(), container.getPassword());
        String previousJdbcUrl = currentJdbcUrl.replace("/current", "/previous");
        TestDatabase currentTDB = SqlTestUtil.initDatabase(currentJdbcUrl, dialect, "current");
        TestDatabase previousTDB = SqlTestUtil.initDatabase(previousJdbcUrl, dialect, "previous");
        return new TestDatabase(currentTDB.dataSource, currentTDB.context, currentTDB.liquibase, previousTDB.dataSource, previousTDB.context, previousTDB.liquibase);
    }

    public static TestDatabase initDatabase(String jdbcUrl) {
        return SqlTestUtil.initDatabase(jdbcUrl, SQLDialect.H2);
    }

    public static TestDatabase initDatabase(String jdbcUrl, SQLDialect dialect) {
        return SqlTestUtil.initDatabase(jdbcUrl, dialect, "test");
    }

    public static TestDatabase initDatabase(String jdbcUrl, SQLDialect dialect, String dbName) {
        Liquibase migrate;
        HikariConfig cpConfig = new HikariConfig();
        cpConfig.setJdbcUrl(jdbcUrl);
        cpConfig.setMaximumPoolSize(5);
        HikariDataSource dataSource = new HikariDataSource(cpConfig);
        DefaultConfiguration config = new DefaultConfiguration();
        config.set((ConnectionProvider)new DataSourceConnectionProvider((DataSource)dataSource));
        config.setSQLDialect(dialect);
        if (dialect == SQLDialect.H2) {
            config.settings().withRenderNameStyle(RenderNameStyle.AS_IS);
        }
        DefaultDSLContext context = new DefaultDSLContext((Configuration)config);
        try {
            DatabaseChangeLog changeLog = new DatabaseChangeLog();
            changeLog.setChangeLogParameters(new ChangeLogParameters(DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(dataSource.getConnection()))));
            changeLog.includeAll("db/changelog/", false, null, false, Comparator.comparing(String::toString), (ResourceAccessor)new ClassLoaderResourceAccessor(), new ContextExpression(), new LabelExpression(), false);
            migrate = new Liquibase(changeLog, (ResourceAccessor)new ClassLoaderResourceAccessor(), DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(dataSource.getConnection())));
        }
        catch (SQLException | DatabaseException | SetupException e) {
            throw new DatabaseInitializationFailed(e);
        }
        try {
            migrate.update(dbName);
        }
        catch (LiquibaseException e) {
            throw new DatabaseInitializationFailed(e);
        }
        return new TestDatabase(dataSource, (DSLContext)context, migrate);
    }

    public static void cleanupDb(DSLContext context) {
        String schema = context.select((SelectField)DSL.currentSchema()).fetch().getValue(0, 0).toString();
        GlobalConfiguration configuration = (GlobalConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class);
        ArrayList<RowCountQuery> commands = new ArrayList<RowCountQuery>();
        if (context.dialect() == SQLDialect.MYSQL) {
            commands.add(DSL.query((String)"set foreign_key_checks=0"));
        }
        context.meta().getTables().stream().filter(table -> table.getType().isTable() && table.getSchema().getName().equals(schema) && !table.getName().equals(configuration.getDatabaseChangeLogTableName()) && !table.getName().equals(configuration.getDatabaseChangeLogLockTableName())).forEach(table -> {
            switch (context.dialect()) {
                case POSTGRES: {
                    commands.add((RowCountQuery)DSL.truncateTable((Table)table).cascade());
                    break;
                }
                default: {
                    commands.add((RowCountQuery)DSL.truncateTable((Table)table));
                }
            }
        });
        if (context.dialect() == SQLDialect.MYSQL) {
            commands.add(DSL.query((String)"set foreign_key_checks=1"));
        }
        context.batch(commands).execute();
    }

    private static class DatabaseInitializationFailed
    extends RuntimeException {
        DatabaseInitializationFailed(Throwable cause) {
            super(cause);
        }
    }

    public static class TestDatabase
    implements Closeable {
        public final HikariDataSource dataSource;
        public final HikariDataSource previousDataSource;
        public final DSLContext context;
        public final DSLContext previousContext;
        public final Liquibase liquibase;
        public final Liquibase previousLiquibase;

        TestDatabase(HikariDataSource dataSource, DSLContext context, Liquibase liquibase) {
            this.dataSource = dataSource;
            this.context = context;
            this.liquibase = liquibase;
            this.previousDataSource = null;
            this.previousContext = null;
            this.previousLiquibase = null;
        }

        TestDatabase(HikariDataSource dataSource, DSLContext context, Liquibase liquibase, HikariDataSource previousDataSource, DSLContext previousContext, Liquibase previousLiquibase) {
            this.dataSource = dataSource;
            this.context = context;
            this.liquibase = liquibase;
            this.previousDataSource = previousDataSource;
            this.previousContext = previousContext;
            this.previousLiquibase = previousLiquibase;
        }

        @Override
        public void close() {
            this.dataSource.close();
            if (this.previousDataSource != null) {
                this.previousDataSource.close();
            }
        }
    }
}

