/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.sql.telemetry;

import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.zaxxer.hikari.metrics.IMetricsTracker;
import com.zaxxer.hikari.metrics.PoolStats;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0006\u0010\u001a\u001a\u00020\u0014R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000b*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/netflix/spinnaker/kork/sql/telemetry/HikariSpectatorMetricsTracker;", "Lcom/zaxxer/hikari/metrics/IMetricsTracker;", "poolName", "", "poolStats", "Lcom/zaxxer/hikari/metrics/PoolStats;", "registry", "Lcom/netflix/spectator/api/Registry;", "(Ljava/lang/String;Lcom/zaxxer/hikari/metrics/PoolStats;Lcom/netflix/spectator/api/Registry;)V", "activeConnectionsGauge", "Lcom/netflix/spectator/api/Gauge;", "kotlin.jvm.PlatformType", "blockedThreadsGauge", "connectionAcquiredId", "Lcom/netflix/spectator/api/Id;", "connectionTimeoutId", "connectionUsageId", "idleConnectionsGauge", "totalConnectionsGauge", "recordConnectionAcquiredNanos", "", "elapsedAcquiredNanos", "", "recordConnectionTimeout", "recordConnectionUsageMillis", "elapsedBorrowedMillis", "recordPoolStats", "kork-sql"})
public final class HikariSpectatorMetricsTracker
implements IMetricsTracker {
    private final Id connectionAcquiredId;
    private final Id connectionUsageId;
    private final Id connectionTimeoutId;
    private final Gauge idleConnectionsGauge;
    private final Gauge activeConnectionsGauge;
    private final Gauge totalConnectionsGauge;
    private final Gauge blockedThreadsGauge;
    private final PoolStats poolStats;
    private final Registry registry;

    public final void recordPoolStats() {
        this.idleConnectionsGauge.set((double)this.poolStats.getIdleConnections());
        this.activeConnectionsGauge.set((double)this.poolStats.getActiveConnections());
        this.totalConnectionsGauge.set((double)this.poolStats.getTotalConnections());
        this.blockedThreadsGauge.set((double)this.poolStats.getPendingThreads());
    }

    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        this.registry.timer(this.connectionAcquiredId).record(elapsedAcquiredNanos, TimeUnit.NANOSECONDS);
    }

    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.registry.timer(this.connectionUsageId).record(elapsedBorrowedMillis, TimeUnit.MILLISECONDS);
    }

    public void recordConnectionTimeout() {
        this.registry.counter(this.connectionTimeoutId).increment();
    }

    public HikariSpectatorMetricsTracker(@NotNull String poolName, @NotNull PoolStats poolStats, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        Intrinsics.checkNotNullParameter((Object)poolStats, (String)"poolStats");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.poolStats = poolStats;
        this.registry = registry;
        this.connectionAcquiredId = this.registry.createId("sql.pool." + poolName + ".connectionAcquiredTiming");
        this.connectionUsageId = this.registry.createId("sql.pool." + poolName + ".connectionUsageTiming");
        this.connectionTimeoutId = this.registry.createId("sql.pool." + poolName + ".connectionTimeout");
        this.idleConnectionsGauge = this.registry.gauge("sql.pool." + poolName + ".idle");
        this.activeConnectionsGauge = this.registry.gauge("sql.pool." + poolName + ".active");
        this.totalConnectionsGauge = this.registry.gauge("sql.pool." + poolName + ".total");
        this.blockedThreadsGauge = this.registry.gauge("sql.pool." + poolName + ".blocked");
    }
}

