/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.sql.health;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010$\u001a\u00020%H\u0007R\u001a\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n  *\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/netflix/spinnaker/kork/sql/health/SqlHealthProvider;", "", "jooq", "Lorg/jooq/DSLContext;", "registry", "Lcom/netflix/spectator/api/Registry;", "readOnly", "", "unhealthyThreshold", "", "healthyThreshold", "(Lorg/jooq/DSLContext;Lcom/netflix/spectator/api/Registry;ZII)V", "_enabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "get_enabled$kork_sql$annotations", "()V", "get_enabled$kork_sql", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "_healthException", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "enabled", "getEnabled", "()Z", "healthException", "getHealthException", "()Ljava/lang/Exception;", "healthyCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "invocationId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "unhealthyCounter", "performCheck", "", "kork-sql"})
public final class SqlHealthProvider {
    @NotNull
    private final DSLContext jooq;
    @NotNull
    private final Registry registry;
    private final boolean readOnly;
    private final int unhealthyThreshold;
    private final int healthyThreshold;
    private final Logger log;
    @NotNull
    private final AtomicBoolean _enabled;
    @NotNull
    private final AtomicReference<Exception> _healthException;
    @NotNull
    private final AtomicInteger healthyCounter;
    @NotNull
    private final AtomicInteger unhealthyCounter;
    private final Id invocationId;

    public SqlHealthProvider(@NotNull DSLContext jooq, @NotNull Registry registry, boolean readOnly, int unhealthyThreshold, int healthyThreshold) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.jooq = jooq;
        this.registry = registry;
        this.readOnly = readOnly;
        this.unhealthyThreshold = unhealthyThreshold;
        this.healthyThreshold = healthyThreshold;
        this.log = LoggerFactory.getLogger(this.getClass());
        this._enabled = new AtomicBoolean(false);
        this._healthException = new AtomicReference();
        this.healthyCounter = new AtomicInteger(0);
        this.unhealthyCounter = new AtomicInteger(0);
        this.invocationId = this.registry.createId("sql.healthProvider.invocations");
    }

    public /* synthetic */ SqlHealthProvider(DSLContext dSLContext, Registry registry, boolean bl, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n = 2;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 10;
        }
        this(dSLContext, registry, bl, n, n2);
    }

    @NotNull
    public final AtomicBoolean get_enabled$kork_sql() {
        return this._enabled;
    }

    public static /* synthetic */ void get_enabled$kork_sql$annotations() {
    }

    public final boolean getEnabled() {
        return this._enabled.get();
    }

    @Nullable
    public final Exception getHealthException() {
        return this._healthException.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelay=1000L)
    public final void performCheck() {
        try {
            if (this.readOnly) {
                this.jooq.select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.table((String)"healthcheck")).limit(1);
            } else {
                this.jooq.delete(DSL.table((String)"healthcheck")).execute();
            }
            if (!this._enabled.get() && this.healthyCounter.incrementAndGet() >= this.healthyThreshold) {
                this._enabled.set(true);
                this._healthException.set(null);
                this.log.info("Enabling after " + this.healthyThreshold + " healthy cycles");
            }
            this.unhealthyCounter.set(0);
            this.registry.counter(this.invocationId.withTag("status", this.getEnabled() ? "enabled" : "disabled")).increment();
        }
        catch (Exception e) {
            try {
                this._healthException.set(e);
                this.healthyCounter.set(0);
                int n = this.unhealthyCounter.incrementAndGet();
                boolean bl = false;
                boolean bl2 = false;
                int unhealthyCount = n;
                boolean bl3 = false;
                this.log.error("Encountered exception, " + unhealthyCount + "/" + this.unhealthyThreshold + " failures", (Throwable)e);
                if (unhealthyCount >= this.unhealthyThreshold && this.get_enabled$kork_sql().get()) {
                    this.log.warn("Encountered exception, disabling after " + unhealthyCount + " failures");
                    this.get_enabled$kork_sql().set(false);
                }
                this.registry.counter(this.invocationId.withTag("status", this.getEnabled() ? "enabled" : "disabled")).increment();
            }
            catch (Throwable throwable) {
                this.registry.counter(this.invocationId.withTag("status", this.getEnabled() ? "enabled" : "disabled")).increment();
                throw throwable;
            }
        }
    }
}

