/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.sql.telemetry;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.ExecuteContext;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.tools.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u0010\u001a\u00020\u0003*\u00020\nH\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/spinnaker/kork/sql/telemetry/JooqSlowQueryLogger;", "Lorg/jooq/impl/DefaultExecuteListener;", "slowQuerySecondsThreshold", "", "(J)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "slowQueryThreshold", "watch", "Lorg/jooq/tools/StopWatch;", "executeEnd", "", "ctx", "Lorg/jooq/ExecuteContext;", "executeStart", "splitToMillis", "kork-sql"})
public final class JooqSlowQueryLogger
extends DefaultExecuteListener {
    private StopWatch watch;
    private final Logger log;
    private final long slowQueryThreshold;

    public JooqSlowQueryLogger(long slowQuerySecondsThreshold) {
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.slowQueryThreshold = TimeUnit.SECONDS.toNanos(slowQuerySecondsThreshold);
    }

    public /* synthetic */ JooqSlowQueryLogger(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        this(l);
    }

    public void executeStart(@NotNull ExecuteContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super.executeStart(ctx);
        this.watch = new StopWatch();
    }

    public void executeEnd(@NotNull ExecuteContext ctx) {
        StopWatch stopWatch;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super.executeEnd(ctx);
        StopWatch stopWatch2 = this.watch;
        if (stopWatch2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"watch");
            stopWatch = null;
        } else {
            stopWatch = stopWatch2;
        }
        if (stopWatch.split() > this.slowQueryThreshold) {
            StopWatch stopWatch3;
            stopWatch2 = this.watch;
            if (stopWatch2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watch");
                stopWatch3 = null;
            } else {
                stopWatch3 = stopWatch2;
            }
            this.log.warn("Slow SQL (" + this.splitToMillis(stopWatch3) + "ms):\n" + ctx.query());
        }
    }

    private final long splitToMillis(StopWatch $this$splitToMillis) {
        return TimeUnit.NANOSECONDS.toMillis($this$splitToMillis.split());
    }

    public JooqSlowQueryLogger() {
        this(0L, 1, null);
    }
}

