/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.sql.config;

import com.netflix.spinnaker.kork.sql.config.ConnectionPoolProperties;
import com.netflix.spinnaker.kork.sql.config.MisconfiguredConnectionPoolsException;
import com.netflix.spinnaker.kork.sql.config.SqlMigrationProperties;
import com.netflix.spinnaker.kork.sql.config.SqlRetryProperties;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.annotation.AnnotationTarget;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@SpinValidated
@ConfigurationProperties(value="sql")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b/\b\u0097\b\u0018\u00002\u00020\u0001:\u0002;<B[\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0010J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\t\u00101\u001a\u00020\fH\u00c6\u0003J\u0010\u00102\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003\u00a2\u0006\u0002\u0010*J\u000b\u00103\u001a\u0004\u0018\u00010\bH\u00c6\u0003Jd\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u00105J\u0013\u00106\u001a\u00020\f2\b\u00107\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u00108\u001a\u00020\bH\u0016J\t\u00109\u001a\u00020\u000eH\u00d6\u0001J\t\u0010:\u001a\u00020\u0007H\u00d6\u0001R&\u0010\u000f\u001a\u0004\u0018\u00010\b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001e\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010,\u001a\u0004\b)\u0010*\"\u0004\b\u000b\u0010+\u00a8\u0006="}, d2={"Lcom/netflix/spinnaker/kork/sql/config/SqlProperties;", "", "migration", "Lcom/netflix/spinnaker/kork/sql/config/SqlMigrationProperties;", "secondaryMigration", "connectionPools", "", "", "Lcom/netflix/spinnaker/kork/sql/config/ConnectionPoolProperties;", "retries", "Lcom/netflix/spinnaker/kork/sql/config/SqlRetryProperties;", "setTransactionIsolation", "", "transactionIsolation", "", "connectionPool", "(Lcom/netflix/spinnaker/kork/sql/config/SqlMigrationProperties;Lcom/netflix/spinnaker/kork/sql/config/SqlMigrationProperties;Ljava/util/Map;Lcom/netflix/spinnaker/kork/sql/config/SqlRetryProperties;ZLjava/lang/Integer;Lcom/netflix/spinnaker/kork/sql/config/ConnectionPoolProperties;)V", "getConnectionPool$annotations", "()V", "getConnectionPool", "()Lcom/netflix/spinnaker/kork/sql/config/ConnectionPoolProperties;", "setConnectionPool", "(Lcom/netflix/spinnaker/kork/sql/config/ConnectionPoolProperties;)V", "getConnectionPools", "()Ljava/util/Map;", "setConnectionPools", "(Ljava/util/Map;)V", "getMigration", "()Lcom/netflix/spinnaker/kork/sql/config/SqlMigrationProperties;", "setMigration", "(Lcom/netflix/spinnaker/kork/sql/config/SqlMigrationProperties;)V", "getRetries", "()Lcom/netflix/spinnaker/kork/sql/config/SqlRetryProperties;", "setRetries", "(Lcom/netflix/spinnaker/kork/sql/config/SqlRetryProperties;)V", "getSecondaryMigration", "setSecondaryMigration", "getSetTransactionIsolation", "()Z", "setSetTransactionIsolation", "(Z)V", "getTransactionIsolation", "()Ljava/lang/Integer;", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Lcom/netflix/spinnaker/kork/sql/config/SqlMigrationProperties;Lcom/netflix/spinnaker/kork/sql/config/SqlMigrationProperties;Ljava/util/Map;Lcom/netflix/spinnaker/kork/sql/config/SqlRetryProperties;ZLjava/lang/Integer;Lcom/netflix/spinnaker/kork/sql/config/ConnectionPoolProperties;)Lcom/netflix/spinnaker/kork/sql/config/SqlProperties;", "equals", "other", "getDefaultConnectionPoolProperties", "hashCode", "toString", "SpinValidated", "Validator", "kork-sql"})
public class SqlProperties {
    @NotNull
    private SqlMigrationProperties migration;
    @NotNull
    private SqlMigrationProperties secondaryMigration;
    @NotNull
    private Map<String, ConnectionPoolProperties> connectionPools;
    @NotNull
    private SqlRetryProperties retries;
    private boolean setTransactionIsolation;
    @Nullable
    private Integer transactionIsolation;
    @Nullable
    private ConnectionPoolProperties connectionPool;

    public SqlProperties(@NotNull SqlMigrationProperties migration, @NotNull SqlMigrationProperties secondaryMigration, @NotNull Map<String, ConnectionPoolProperties> connectionPools, @NotNull SqlRetryProperties retries, boolean setTransactionIsolation, @Nullable Integer transactionIsolation, @Nullable ConnectionPoolProperties connectionPool) {
        Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
        Intrinsics.checkNotNullParameter((Object)secondaryMigration, (String)"secondaryMigration");
        Intrinsics.checkNotNullParameter(connectionPools, (String)"connectionPools");
        Intrinsics.checkNotNullParameter((Object)retries, (String)"retries");
        this.migration = migration;
        this.secondaryMigration = secondaryMigration;
        this.connectionPools = connectionPools;
        this.retries = retries;
        this.setTransactionIsolation = setTransactionIsolation;
        this.transactionIsolation = transactionIsolation;
        this.connectionPool = connectionPool;
    }

    public /* synthetic */ SqlProperties(SqlMigrationProperties sqlMigrationProperties, SqlMigrationProperties sqlMigrationProperties2, Map map, SqlRetryProperties sqlRetryProperties, boolean bl, Integer n, ConnectionPoolProperties connectionPoolProperties, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            sqlMigrationProperties = new SqlMigrationProperties(null, null, null, null, null, null, 63, null);
        }
        if ((n2 & 2) != 0) {
            sqlMigrationProperties2 = new SqlMigrationProperties(null, null, null, null, null, null, 63, null);
        }
        if ((n2 & 4) != 0) {
            map = new LinkedHashMap();
        }
        if ((n2 & 8) != 0) {
            sqlRetryProperties = new SqlRetryProperties(null, null, 3, null);
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            n = 2;
        }
        if ((n2 & 0x40) != 0) {
            connectionPoolProperties = null;
        }
        this(sqlMigrationProperties, sqlMigrationProperties2, map, sqlRetryProperties, bl, n, connectionPoolProperties);
    }

    @NotNull
    public SqlMigrationProperties getMigration() {
        return this.migration;
    }

    public void setMigration(@NotNull SqlMigrationProperties sqlMigrationProperties) {
        Intrinsics.checkNotNullParameter((Object)sqlMigrationProperties, (String)"<set-?>");
        this.migration = sqlMigrationProperties;
    }

    @NotNull
    public SqlMigrationProperties getSecondaryMigration() {
        return this.secondaryMigration;
    }

    public void setSecondaryMigration(@NotNull SqlMigrationProperties sqlMigrationProperties) {
        Intrinsics.checkNotNullParameter((Object)sqlMigrationProperties, (String)"<set-?>");
        this.secondaryMigration = sqlMigrationProperties;
    }

    @NotNull
    public Map<String, ConnectionPoolProperties> getConnectionPools() {
        return this.connectionPools;
    }

    public void setConnectionPools(@NotNull Map<String, ConnectionPoolProperties> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.connectionPools = map;
    }

    @NotNull
    public SqlRetryProperties getRetries() {
        return this.retries;
    }

    public void setRetries(@NotNull SqlRetryProperties sqlRetryProperties) {
        Intrinsics.checkNotNullParameter((Object)sqlRetryProperties, (String)"<set-?>");
        this.retries = sqlRetryProperties;
    }

    public boolean getSetTransactionIsolation() {
        return this.setTransactionIsolation;
    }

    public void setSetTransactionIsolation(boolean bl) {
        this.setTransactionIsolation = bl;
    }

    @Nullable
    public Integer getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(@Nullable Integer n) {
        this.transactionIsolation = n;
    }

    @Nullable
    public ConnectionPoolProperties getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(@Nullable ConnectionPoolProperties connectionPoolProperties) {
        this.connectionPool = connectionPoolProperties;
    }

    @Deprecated(message="use named connection pools instead")
    public static /* synthetic */ void getConnectionPool$annotations() {
    }

    @NotNull
    public ConnectionPoolProperties getDefaultConnectionPoolProperties() {
        ConnectionPoolProperties connectionPoolProperties;
        if (this.getConnectionPools().isEmpty()) {
            if (this.getConnectionPool() == null) {
                throw MisconfiguredConnectionPoolsException.Companion.getNEITHER_PRESENT();
            }
            ConnectionPoolProperties connectionPoolProperties2 = this.getConnectionPool();
            Intrinsics.checkNotNull((Object)connectionPoolProperties2);
            return connectionPoolProperties2;
        }
        if (this.getConnectionPools().size() == 1) {
            connectionPoolProperties = (ConnectionPoolProperties)CollectionsKt.first((Iterable)this.getConnectionPools().values());
        } else {
            Object element$iv2;
            block5: {
                Iterable $this$first$iv = this.getConnectionPools().values();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ConnectionPoolProperties it = (ConnectionPoolProperties)element$iv2;
                    boolean bl = false;
                    if (!it.getDefault()) continue;
                    break block5;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            connectionPoolProperties = (ConnectionPoolProperties)element$iv2;
        }
        return connectionPoolProperties;
    }

    @NotNull
    public final SqlMigrationProperties component1() {
        return this.getMigration();
    }

    @NotNull
    public final SqlMigrationProperties component2() {
        return this.getSecondaryMigration();
    }

    @NotNull
    public final Map<String, ConnectionPoolProperties> component3() {
        return this.getConnectionPools();
    }

    @NotNull
    public final SqlRetryProperties component4() {
        return this.getRetries();
    }

    public final boolean component5() {
        return this.getSetTransactionIsolation();
    }

    @Nullable
    public final Integer component6() {
        return this.getTransactionIsolation();
    }

    @Nullable
    public final ConnectionPoolProperties component7() {
        return this.getConnectionPool();
    }

    @NotNull
    public final SqlProperties copy(@NotNull SqlMigrationProperties migration, @NotNull SqlMigrationProperties secondaryMigration, @NotNull Map<String, ConnectionPoolProperties> connectionPools, @NotNull SqlRetryProperties retries, boolean setTransactionIsolation, @Nullable Integer transactionIsolation, @Nullable ConnectionPoolProperties connectionPool) {
        Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
        Intrinsics.checkNotNullParameter((Object)secondaryMigration, (String)"secondaryMigration");
        Intrinsics.checkNotNullParameter(connectionPools, (String)"connectionPools");
        Intrinsics.checkNotNullParameter((Object)retries, (String)"retries");
        return new SqlProperties(migration, secondaryMigration, connectionPools, retries, setTransactionIsolation, transactionIsolation, connectionPool);
    }

    public static /* synthetic */ SqlProperties copy$default(SqlProperties sqlProperties, SqlMigrationProperties sqlMigrationProperties, SqlMigrationProperties sqlMigrationProperties2, Map map, SqlRetryProperties sqlRetryProperties, boolean bl, Integer n, ConnectionPoolProperties connectionPoolProperties, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n2 & 1) != 0) {
            sqlMigrationProperties = sqlProperties.getMigration();
        }
        if ((n2 & 2) != 0) {
            sqlMigrationProperties2 = sqlProperties.getSecondaryMigration();
        }
        if ((n2 & 4) != 0) {
            map = sqlProperties.getConnectionPools();
        }
        if ((n2 & 8) != 0) {
            sqlRetryProperties = sqlProperties.getRetries();
        }
        if ((n2 & 0x10) != 0) {
            bl = sqlProperties.getSetTransactionIsolation();
        }
        if ((n2 & 0x20) != 0) {
            n = sqlProperties.getTransactionIsolation();
        }
        if ((n2 & 0x40) != 0) {
            connectionPoolProperties = sqlProperties.getConnectionPool();
        }
        return sqlProperties.copy(sqlMigrationProperties, sqlMigrationProperties2, map, sqlRetryProperties, bl, n, connectionPoolProperties);
    }

    @NotNull
    public String toString() {
        return "SqlProperties(migration=" + this.getMigration() + ", secondaryMigration=" + this.getSecondaryMigration() + ", connectionPools=" + this.getConnectionPools() + ", retries=" + this.getRetries() + ", setTransactionIsolation=" + this.getSetTransactionIsolation() + ", transactionIsolation=" + this.getTransactionIsolation() + ", connectionPool=" + this.getConnectionPool() + ")";
    }

    public int hashCode() {
        int result = this.getMigration().hashCode();
        result = result * 31 + this.getSecondaryMigration().hashCode();
        result = result * 31 + ((Object)this.getConnectionPools()).hashCode();
        result = result * 31 + this.getRetries().hashCode();
        int n = this.getSetTransactionIsolation() ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + (this.getTransactionIsolation() == null ? 0 : ((Object)this.getTransactionIsolation()).hashCode());
        result = result * 31 + (this.getConnectionPool() == null ? 0 : this.getConnectionPool().hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SqlProperties)) {
            return false;
        }
        SqlProperties sqlProperties = (SqlProperties)other;
        if (!Intrinsics.areEqual((Object)this.getMigration(), (Object)sqlProperties.getMigration())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getSecondaryMigration(), (Object)sqlProperties.getSecondaryMigration())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getConnectionPools(), sqlProperties.getConnectionPools())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getRetries(), (Object)sqlProperties.getRetries())) {
            return false;
        }
        if (this.getSetTransactionIsolation() != sqlProperties.getSetTransactionIsolation()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTransactionIsolation(), (Object)sqlProperties.getTransactionIsolation())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getConnectionPool(), (Object)sqlProperties.getConnectionPool());
    }

    public SqlProperties() {
        this(null, null, null, null, false, null, null, 127, null);
    }

    @Validated
    @Constraint(validatedBy={Validator.class})
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.CLASS})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0097\u0002\u0018\u00002\u00020\u0001B:\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005R \u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\tR\u0012\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\nR \u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/netflix/spinnaker/kork/sql/config/SqlProperties$SpinValidated;", "", "message", "", "groups", "", "Lkotlin/reflect/KClass;", "", "payload", "()[Ljava/lang/Class;", "()Ljava/lang/String;", "kork-sql"})
    public static @interface SpinValidated {
        public String message() default "Invalid sql configuration";

        public Class<? extends Object>[] groups() default {};

        public Class<? extends Object>[] payload() default {};
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/kork/sql/config/SqlProperties$Validator;", "Ljavax/validation/ConstraintValidator;", "Lcom/netflix/spinnaker/kork/sql/config/SqlProperties$SpinValidated;", "Lcom/netflix/spinnaker/kork/sql/config/SqlProperties;", "()V", "isValid", "", "value", "context", "Ljavax/validation/ConstraintValidatorContext;", "kork-sql"})
    public static final class Validator
    implements ConstraintValidator<SpinValidated, SqlProperties> {
        public boolean isValid(@NotNull SqlProperties value, @NotNull ConstraintValidatorContext context) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (value.getSetTransactionIsolation() && value.getTransactionIsolation() == null) {
                context.buildConstraintViolationWithTemplate("must specify transactionIsolation if setTransactionIsolation is true").addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

