/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.sql.config;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.sql.JooqSqlCommentAppender;
import com.netflix.spinnaker.kork.sql.JooqToSpringExceptionTransformer;
import com.netflix.spinnaker.kork.sql.config.ConnectionPoolProperties;
import com.netflix.spinnaker.kork.sql.config.DataSourceFactory;
import com.netflix.spinnaker.kork.sql.config.DefaultSqlConfigurationKt;
import com.netflix.spinnaker.kork.sql.config.HikariDataSourceConfiguration;
import com.netflix.spinnaker.kork.sql.config.MisconfiguredConnectionPoolsException;
import com.netflix.spinnaker.kork.sql.config.SecondaryPoolDialectCondition;
import com.netflix.spinnaker.kork.sql.config.SqlProperties;
import com.netflix.spinnaker.kork.sql.config.TargetDataSource;
import com.netflix.spinnaker.kork.sql.health.SqlHealthIndicator;
import com.netflix.spinnaker.kork.sql.health.SqlHealthProvider;
import com.netflix.spinnaker.kork.sql.migration.SpringLiquibaseProxy;
import com.netflix.spinnaker.kork.sql.routing.NamedDataSourceRouter;
import com.netflix.spinnaker.kork.sql.routing.StaticDataSourceLookup;
import com.netflix.spinnaker.kork.sql.telemetry.JooqSlowQueryLogger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import liquibase.integration.spring.SpringLiquibase;
import org.jetbrains.annotations.NotNull;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.metrics.jdbc.DataSourcePoolMetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvidersConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

@org.springframework.context.annotation.Configuration
@ConditionalOnProperty(value={"sql.enabled"})
@EnableConfigurationProperties(value={SqlProperties.class})
@EnableAutoConfiguration(exclude={DataSourceAutoConfiguration.class, DataSourcePoolMetricsAutoConfiguration.class})
@Import(value={HikariDataSourceConfiguration.class, DataSourcePoolMetadataProvidersConfiguration.class})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0017J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000bH\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0017J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0017J\u001a\u0010\u001d\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0017J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010 \u001a\u00020\u001bH\u0017J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/netflix/spinnaker/kork/sql/config/DefaultSqlConfiguration;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "dataSource", "Ljavax/sql/DataSource;", "dataSourceFactory", "Lcom/netflix/spinnaker/kork/sql/config/DataSourceFactory;", "properties", "Lcom/netflix/spinnaker/kork/sql/config/SqlProperties;", "dataSourceConnectionProvider", "Lorg/jooq/impl/DataSourceConnectionProvider;", "sqlProperties", "dbHealthIndicator", "Lcom/netflix/spinnaker/kork/sql/health/SqlHealthIndicator;", "sqlHealthProvider", "Lcom/netflix/spinnaker/kork/sql/health/SqlHealthProvider;", "jooq", "Lorg/jooq/DSLContext;", "jooqConfiguration", "Lorg/jooq/impl/DefaultConfiguration;", "connectionProvider", "liquibase", "Lliquibase/integration/spring/SpringLiquibase;", "sqlReadOnly", "", "secondaryJooq", "secondaryLiquibase", "registry", "Lcom/netflix/spectator/api/Registry;", "readOnly", "transactionManager", "Lorg/springframework/jdbc/datasource/DataSourceTransactionManager;", "kork-sql"})
public class DefaultSqlConfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public DefaultSqlConfiguration() {
        System.setProperty("org.jooq.no-logo", "true");
    }

    @Bean
    @ConditionalOnMissingBean(value={SpringLiquibase.class})
    @NotNull
    public SpringLiquibase liquibase(@NotNull SqlProperties properties, @Value(value="${sql.read-only:false}") boolean sqlReadOnly) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new SpringLiquibaseProxy(properties.getMigration(), sqlReadOnly, null, 4, null);
    }

    @Bean
    @ConditionalOnProperty(value={"sql.secondary-migration.jdbc-url"})
    @NotNull
    public SpringLiquibase secondaryLiquibase(@NotNull SqlProperties properties, @Value(value="${sql.read-only:false}") boolean sqlReadOnly) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return new SpringLiquibaseProxy(properties.getSecondaryMigration(), sqlReadOnly, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @DependsOn(value={"liquibase"})
    @Bean
    @NotNull
    public DataSource dataSource(@NotNull DataSourceFactory dataSourceFactory, @NotNull SqlProperties properties) {
        Object element$iv22;
        NamedDataSourceRouter dataSource;
        Object object;
        block10: {
            void $this$first$iv;
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)dataSourceFactory, (String)"dataSourceFactory");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            if (!properties.getConnectionPools().isEmpty() && properties.getConnectionPool() != null) {
                throw MisconfiguredConnectionPoolsException.Companion.getBOTH_PRESENT();
            }
            if (properties.getConnectionPools().isEmpty()) {
                if (properties.getConnectionPool() == null) {
                    throw MisconfiguredConnectionPoolsException.Companion.getNEITHER_PRESENT();
                }
                this.log.warn("Use of 'sql.connectionPool' configuration is deprecated, use 'sql.connectionPools' instead");
                ConnectionPoolProperties connectionPoolProperties = properties.getConnectionPool();
                Intrinsics.checkNotNull((Object)connectionPoolProperties);
                return dataSourceFactory.build("default", connectionPoolProperties);
            }
            Map<String, ConnectionPoolProperties> map = properties.getConnectionPools();
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Map.Entry entry;
                it = entry = iterator.next();
                boolean bl2 = false;
                if (((ConnectionPoolProperties)it.getValue()).getJdbcUrl() == null) {
                    this.log.warn("Skipping creation of connection pool '" + it.getKey() + "': No jdbcUrl configured, but other config values present");
                    bl = false;
                } else {
                    bl = true;
                }
                if (!bl) continue;
                destination$iv$iv.put(entry.getKey(), entry.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv2.entrySet()) {
                it = entry;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(new Pair(it.getKey(), (Object)new TargetDataSource(dataSourceFactory.build((String)it.getKey(), (ConnectionPoolProperties)it.getValue()), properties.getConnectionPools().size() == 1 ? true : ((ConnectionPoolProperties)it.getValue()).getDefault(), (String)it.getKey())));
            }
            Map targets = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            if (targets.size() == 1) {
                return ((TargetDataSource)CollectionsKt.first((Iterable)targets.values())).getDataSource();
            }
            DefaultSqlConfigurationKt.access$validateDefaultTargetDataSources(targets.values());
            Map $this$map$iv2 = targets;
            boolean $i$f$map232 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it2;
                Map.Entry item$iv$iv3;
                Map.Entry bl = item$iv$iv3 = iterator2.next();
                object = destination$iv$iv2;
                boolean bl3 = false;
                String string = ((String)it2.getKey()).toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
                object.add(TuplesKt.to((Object)string, (Object)((TargetDataSource)it2.getValue()).getDataSource()));
            }
            Map dataSources = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            dataSource = new NamedDataSourceRouter();
            dataSource.setTargetDataSources(dataSources);
            dataSource.setDataSourceLookup(new StaticDataSourceLookup(dataSources));
            Iterable $i$f$map232 = targets.values();
            object = dataSource;
            boolean $i$f$first = false;
            for (Object element$iv22 : $this$first$iv) {
                TargetDataSource targetDataSource = (TargetDataSource)element$iv22;
                boolean bl = false;
                if (!targetDataSource.getDefault()) continue;
                break block10;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        object.setDefaultTargetDataSource((Object)((TargetDataSource)element$iv22).getDataSource());
        return (DataSource)((Object)dataSource);
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSourceTransactionManager.class})
    @NotNull
    public DataSourceTransactionManager transactionManager(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    @ConditionalOnMissingBean(value={DataSourceConnectionProvider.class})
    @NotNull
    public DataSourceConnectionProvider dataSourceConnectionProvider(@NotNull DataSource dataSource, @NotNull SqlProperties sqlProperties) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)sqlProperties, (String)"sqlProperties");
        TransactionAwareDataSourceProxy transactionAwareDataSourceProxy = new TransactionAwareDataSourceProxy(dataSource);
        return new DataSourceConnectionProvider(sqlProperties, transactionAwareDataSourceProxy){
            final /* synthetic */ SqlProperties $sqlProperties;
            {
                this.$sqlProperties = $sqlProperties;
                super((DataSource)$super_call_param$1);
            }

            @NotNull
            public Connection acquire() {
                Connection connection = super.acquire();
                Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"super.acquire()");
                Connection connection2 = connection;
                SqlProperties sqlProperties = this.$sqlProperties;
                Connection $this$acquire_u24lambda_u2d0 = connection2;
                boolean bl = false;
                if (sqlProperties.getSetTransactionIsolation()) {
                    DatabaseMetaData databaseMetaData = $this$acquire_u24lambda_u2d0.getMetaData();
                    Integer n = sqlProperties.getTransactionIsolation();
                    Intrinsics.checkNotNull((Object)n);
                    if (databaseMetaData.supportsTransactionIsolationLevel(n)) {
                        Integer n2 = sqlProperties.getTransactionIsolation();
                        Intrinsics.checkNotNull((Object)n2);
                        $this$acquire_u24lambda_u2d0.setTransactionIsolation(n2);
                    }
                }
                return connection2;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultConfiguration.class})
    @NotNull
    public DefaultConfiguration jooqConfiguration(@NotNull DataSourceConnectionProvider connectionProvider, @NotNull SqlProperties properties) {
        DefaultConfiguration defaultConfiguration;
        Intrinsics.checkNotNullParameter((Object)connectionProvider, (String)"connectionProvider");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        DefaultConfiguration $this$jooqConfiguration_u24lambda_u2d4 = defaultConfiguration = new DefaultConfiguration();
        boolean bl = false;
        ExecuteListener[] executeListenerArray = new ExecuteListener[]{(ExecuteListener)new JooqToSpringExceptionTransformer(), (ExecuteListener)new JooqSqlCommentAppender(), (ExecuteListener)new JooqSlowQueryLogger(0L, 1, null)};
        ExecuteListenerProvider[] executeListenerProviderArray = DefaultExecuteListenerProvider.providers((ExecuteListener[])executeListenerArray);
        $this$jooqConfiguration_u24lambda_u2d4.set(Arrays.copyOf(executeListenerProviderArray, executeListenerProviderArray.length));
        $this$jooqConfiguration_u24lambda_u2d4.set((ConnectionProvider)connectionProvider);
        $this$jooqConfiguration_u24lambda_u2d4.setSQLDialect(properties.getDefaultConnectionPoolProperties().getDialect());
        return defaultConfiguration;
    }

    @Bean(destroyMethod="")
    @ConditionalOnMissingBean(value={DSLContext.class})
    @NotNull
    public DSLContext jooq(@NotNull DefaultConfiguration jooqConfiguration) {
        Intrinsics.checkNotNullParameter((Object)jooqConfiguration, (String)"jooqConfiguration");
        return (DSLContext)new DefaultDSLContext((Configuration)jooqConfiguration);
    }

    /*
     * WARNING - void declaration
     */
    @Bean(destroyMethod="")
    @Conditional(value={SecondaryPoolDialectCondition.class})
    @NotNull
    public DSLContext secondaryJooq(@NotNull DataSourceConnectionProvider connectionProvider, @NotNull SqlProperties sqlProperties) {
        DefaultConfiguration defaultConfiguration;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)connectionProvider, (String)"connectionProvider");
        Intrinsics.checkNotNullParameter((Object)sqlProperties, (String)"sqlProperties");
        Map<String, ConnectionPoolProperties> map = sqlProperties.getConnectionPools();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        ExecuteListenerProvider[] executeListenerProviderArray = $this$filterTo$iv$iv.entrySet().iterator();
        while (executeListenerProviderArray.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = executeListenerProviderArray.next();
            boolean bl = false;
            if (!(!((ConnectionPoolProperties)it.getValue()).getDefault())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        ConnectionPoolProperties secondaryPool = (ConnectionPoolProperties)CollectionsKt.first((Iterable)destination$iv$iv.values());
        DefaultConfiguration $this$secondaryJooq_u24lambda_u2d6 = defaultConfiguration = new DefaultConfiguration();
        boolean bl = false;
        ExecuteListener[] executeListenerArray = new ExecuteListener[]{(ExecuteListener)new JooqToSpringExceptionTransformer(), (ExecuteListener)new JooqSqlCommentAppender(), (ExecuteListener)new JooqSlowQueryLogger(0L, 1, null)};
        executeListenerProviderArray = DefaultExecuteListenerProvider.providers((ExecuteListener[])executeListenerArray);
        $this$secondaryJooq_u24lambda_u2d6.set(Arrays.copyOf(executeListenerProviderArray, executeListenerProviderArray.length));
        $this$secondaryJooq_u24lambda_u2d6.set((ConnectionProvider)connectionProvider);
        $this$secondaryJooq_u24lambda_u2d6.setSQLDialect(secondaryPool.getDialect());
        DefaultConfiguration secondaryJooqConfig = defaultConfiguration;
        return (DSLContext)new DefaultDSLContext((Configuration)secondaryJooqConfig);
    }

    @Bean
    @NotNull
    public SqlHealthProvider sqlHealthProvider(@NotNull DSLContext jooq, @NotNull Registry registry, @Value(value="${sql.read-only:false}") boolean readOnly) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return new SqlHealthProvider(jooq, registry, readOnly, 0, 0, 24, null);
    }

    @Bean(value={"dbHealthIndicator"})
    @NotNull
    public SqlHealthIndicator dbHealthIndicator(@NotNull SqlHealthProvider sqlHealthProvider, @NotNull SqlProperties sqlProperties) {
        Intrinsics.checkNotNullParameter((Object)sqlHealthProvider, (String)"sqlHealthProvider");
        Intrinsics.checkNotNullParameter((Object)sqlProperties, (String)"sqlProperties");
        return new SqlHealthIndicator(sqlHealthProvider, sqlProperties.getDefaultConnectionPoolProperties().getDialect());
    }
}

