/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.sql.config;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.sql.config.DataSourceFactory;
import com.netflix.spinnaker.kork.sql.config.HikariDataSourceFactory;
import com.netflix.spinnaker.kork.sql.telemetry.HikariSpectatorMetricsTrackerFactory;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={DataSourceFactory.class})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/kork/sql/config/HikariDataSourceConfiguration;", "", "()V", "dataSourceFactory", "Lcom/netflix/spinnaker/kork/sql/config/DataSourceFactory;", "metricsTrackerFactory", "Lcom/zaxxer/hikari/metrics/MetricsTrackerFactory;", "hikariMetricsTrackerFactory", "registry", "Lcom/netflix/spectator/api/Registry;", "kork-sql"})
public class HikariDataSourceConfiguration {
    @Bean
    @NotNull
    public MetricsTrackerFactory hikariMetricsTrackerFactory(@NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return new HikariSpectatorMetricsTrackerFactory(registry);
    }

    @Bean
    @NotNull
    public DataSourceFactory dataSourceFactory(@NotNull MetricsTrackerFactory metricsTrackerFactory) {
        Intrinsics.checkNotNullParameter((Object)metricsTrackerFactory, (String)"metricsTrackerFactory");
        return new HikariDataSourceFactory(metricsTrackerFactory);
    }
}

