/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.sql.config;

import com.netflix.spinnaker.kork.sql.config.ConnectionPoolProperties;
import com.netflix.spinnaker.kork.sql.config.SqlProperties;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J \u0010\u000b\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\r2\u0006\u0010\u000f\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/netflix/spinnaker/kork/sql/config/SecondaryPoolDialectCondition;", "Lorg/springframework/boot/autoconfigure/condition/SpringBootCondition;", "()V", "getMatchOutcome", "Lorg/springframework/boot/autoconfigure/condition/ConditionOutcome;", "context", "Lorg/springframework/context/annotation/ConditionContext;", "metadata", "Lorg/springframework/core/type/AnnotatedTypeMetadata;", "hasDifferentDialect", "", "first", "Lcom/netflix/spinnaker/kork/sql/config/ConnectionPoolProperties;", "", "", "default", "kork-sql"})
public final class SecondaryPoolDialectCondition
extends SpringBootCondition {
    @NotNull
    public ConditionOutcome getMatchOutcome(@Nullable ConditionContext context, @Nullable AnnotatedTypeMetadata metadata) {
        return new ConditionOutcome(this.hasDifferentDialect(context), "SQL Dialect check did not pass");
    }

    private final boolean hasDifferentDialect(ConditionContext context) {
        ConditionContext conditionContext = context;
        Object object = Binder.get((Environment)(conditionContext != null ? conditionContext.getEnvironment() : null)).bind(ConfigurationPropertyName.of((CharSequence)"sql"), Bindable.of(SqlProperties.class)).orElse((Object)new SqlProperties(null, null, null, null, false, null, null, 127, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(context?.environment\u2026 .orElse(SqlProperties())");
        SqlProperties sqlProperties = (SqlProperties)object;
        if (sqlProperties.getConnectionPools().size() <= 1 || sqlProperties.getConnectionPools().size() > 2) {
            return false;
        }
        ConnectionPoolProperties defaultPool = this.first(sqlProperties.getConnectionPools(), true);
        ConnectionPoolProperties secondaryPool = this.first(sqlProperties.getConnectionPools(), false);
        return defaultPool.getDialect() != secondaryPool.getDialect();
    }

    /*
     * WARNING - void declaration
     */
    private final ConnectionPoolProperties first(Map<String, ConnectionPoolProperties> $this$first, boolean bl) {
        void $this$filterTo$iv$iv;
        Map<String, ConnectionPoolProperties> $this$filter$iv = $this$first;
        boolean $i$f$filter = false;
        Map<String, ConnectionPoolProperties> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            boolean bl3 = bl ? ((ConnectionPoolProperties)it.getValue()).getDefault() : !((ConnectionPoolProperties)it.getValue()).getDefault();
            if (!bl3) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return (ConnectionPoolProperties)CollectionsKt.first((Iterable)destination$iv$iv.values());
    }
}

