/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stackdriver;

import com.google.api.services.monitoring.v3.model.MonitoredResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MonitoredResourceBuilder {
    private String stackdriverProjectId = "";

    MonitoredResourceBuilder() {
    }

    MonitoredResourceBuilder setStackdriverProject(String name) {
        this.stackdriverProjectId = name;
        return this;
    }

    public String determineProjectName(String defaultProjectName) {
        if (defaultProjectName != null && !defaultProjectName.isEmpty()) {
            return defaultProjectName;
        }
        try {
            return this.getGoogleMetadataValue("project/project-id");
        }
        catch (IOException ioex) {
            return defaultProjectName;
        }
    }

    private String getConnectionValue(HttpURLConnection con) throws IOException {
        int responseCode = con.getResponseCode();
        if (responseCode < 200 || responseCode > 299) {
            throw new IOException("Unexpected responseCode " + responseCode);
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(con.getInputStream(), "US-ASCII"));
        StringBuffer value = new StringBuffer();
        String line = input.readLine();
        while (line != null) {
            value.append(line);
            line = input.readLine();
        }
        input.close();
        return value.toString();
    }

    String getGoogleMetadataValue(String key) throws IOException {
        URL url = new URL(String.format("http://169.254.169.254/computeMetadata/v1/%s", key));
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setConnectTimeout(1000);
        con.setInstanceFollowRedirects(true);
        con.setRequestMethod("GET");
        con.setRequestProperty("Metadata-Flavor", "Google");
        return this.getConnectionValue(con);
    }

    boolean maybeCollectGceInstanceLabels(Map<String, String> labels) {
        try {
            String id = this.getGoogleMetadataValue("instance/id");
            String zone = this.getGoogleMetadataValue("instance/zone");
            zone = zone.substring(zone.lastIndexOf(47) + 1);
            labels.put("instance_id", id);
            labels.put("zone", zone);
            return true;
        }
        catch (IOException ioex) {
            return false;
        }
    }

    boolean maybeCollectGkeInstanceLabels(Map<String, String> labels) {
        return false;
    }

    String matchAttribute(String text, String key) {
        String regex = String.format("\"%s\" : \"(.+?)\"", key);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        return m.find() ? m.group(1) : "";
    }

    String getAwsIdentityDocument() throws IOException {
        URL url = new URL("http://169.254.169.254/latest/dynamic/instance-identity/document");
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setConnectTimeout(1000);
        con.setRequestMethod("GET");
        return this.getConnectionValue(con);
    }

    boolean maybeCollectEc2InstanceLabels(Map<String, String> labels) {
        String doc;
        try {
            doc = this.getAwsIdentityDocument();
        }
        catch (IOException ioex) {
            return false;
        }
        String id = this.matchAttribute(doc, "instanceId");
        String account = this.matchAttribute(doc, "accountId");
        String region = this.matchAttribute(doc, "region");
        if (id.isEmpty() || account.isEmpty() || region.isEmpty()) {
            return false;
        }
        if (this.stackdriverProjectId.isEmpty()) {
            throw new IllegalStateException("stackdriverProjectId was not set.");
        }
        labels.put("instance_id", id);
        labels.put("region", region);
        labels.put("aws_account", account);
        labels.put("project_id", this.stackdriverProjectId);
        return true;
    }

    public MonitoredResource build() throws IOException {
        HashMap<String, String> labels = new HashMap<String, String>();
        MonitoredResource resource = new MonitoredResource();
        if (this.maybeCollectGceInstanceLabels(labels)) {
            resource.setType("gce_instance");
        } else if (this.maybeCollectGkeInstanceLabels(labels)) {
            resource.setType("gke_container");
        } else if (this.maybeCollectEc2InstanceLabels(labels)) {
            resource.setType("aws_ec2_instance");
        } else {
            if (this.stackdriverProjectId.isEmpty()) {
                throw new IllegalStateException("stackdriverProjectId was not set.");
            }
            labels.put("project_id", this.stackdriverProjectId);
            resource.setType("global");
        }
        resource.setLabels(labels);
        return resource;
    }
}

