/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stackdriver;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.monitoring.v3.Monitoring;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.stackdriver.MetricDescriptorCache;
import com.netflix.spectator.stackdriver.MonitoredResourceBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigParams {
    protected Monitoring monitoring;
    protected String projectName;
    protected String customTypeNamespace;
    protected String applicationName;
    protected String instanceId;
    protected Function<String, String> determineProjectName = defaultName -> new MonitoredResourceBuilder().determineProjectName((String)defaultName);
    protected Predicate<Measurement> measurementFilter;
    protected MetricDescriptorCache descriptorCache;
    protected long counterStartTime;

    public String getCustomTypeNamespace() {
        return this.customTypeNamespace;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Predicate<Measurement> getMeasurementFilter() {
        return this.measurementFilter;
    }

    public Monitoring getStackdriverStub() {
        return this.monitoring;
    }

    public MetricDescriptorCache getDescriptorCache() {
        return this.descriptorCache;
    }

    public long getCounterStartTime() {
        return this.counterStartTime;
    }

    public static class Builder
    extends ConfigParams {
        private String credentialsPath;

        private String validateString(String value, String purpose) {
            if (value == null || value.isEmpty()) {
                throw new IllegalStateException("The " + purpose + " has not been specified.");
            }
            return value;
        }

        public ConfigParams build() {
            ConfigParams result = new ConfigParams();
            String actualProjectName = (String)this.determineProjectName.apply(this.projectName);
            result.projectName = this.validateString(actualProjectName, "stackdriver projectName");
            result.applicationName = this.validateString(this.applicationName, "applicationName");
            result.customTypeNamespace = this.validateString(this.customTypeNamespace, "stackdriver customTypeNamespace");
            result.counterStartTime = this.counterStartTime;
            result.measurementFilter = this.measurementFilter;
            result.instanceId = this.instanceId;
            result.monitoring = this.monitoring;
            result.descriptorCache = this.descriptorCache;
            if (result.instanceId == null || result.instanceId.isEmpty()) {
                UUID uuid = UUID.randomUUID();
                byte[] uuidBytes = new byte[16];
                this.addLong(uuidBytes, 0, uuid.getLeastSignificantBits());
                this.addLong(uuidBytes, 8, uuid.getMostSignificantBits());
                result.instanceId = Base64.getEncoder().encodeToString(uuidBytes);
            }
            if (result.monitoring == null) {
                try {
                    NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
                    GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
                    GoogleCredential credential = Builder.loadCredential((HttpTransport)transport, (JsonFactory)jsonFactory, this.credentialsPath);
                    String version = this.getClass().getPackage().getImplementationVersion();
                    if (version == null) {
                        version = "Unknown";
                    }
                    result.monitoring = new Monitoring.Builder((HttpTransport)transport, (JsonFactory)jsonFactory, (HttpRequestInitializer)credential).setApplicationName("Spinnaker/" + version).build();
                }
                catch (IOException | GeneralSecurityException e) {
                    Logger log = LoggerFactory.getLogger((String)"StackdriverWriter");
                    log.error("Caught exception initializing client: " + e);
                    throw new IllegalStateException(e);
                }
            }
            if (result.descriptorCache == null) {
                result.descriptorCache = new MetricDescriptorCache(result);
            }
            return result;
        }

        public Builder setDetermineProjectName(Function<String, String> fn) {
            this.determineProjectName = fn;
            return this;
        }

        public Builder setCustomTypeNamespace(String name) {
            this.customTypeNamespace = name;
            return this;
        }

        public Builder setProjectName(String name) {
            this.projectName = name;
            return this;
        }

        public Builder setCredentialsPath(String path) {
            this.credentialsPath = path;
            return this;
        }

        public Builder setApplicationName(String name) {
            this.applicationName = name;
            return this;
        }

        public Builder setInstanceId(String id) {
            this.instanceId = id;
            return this;
        }

        public Builder setMeasurementFilter(Predicate<Measurement> filter) {
            this.measurementFilter = filter;
            return this;
        }

        public Builder setStackdriverStub(Monitoring stub) {
            this.monitoring = stub;
            return this;
        }

        public Builder setDescriptorCache(MetricDescriptorCache cache) {
            this.descriptorCache = cache;
            return this;
        }

        public Builder setCounterStartTime(long millis) {
            this.counterStartTime = millis;
            return this;
        }

        private void addLong(byte[] buffer, int offset, long value) {
            for (int i = 0; i < 8; ++i) {
                buffer[i + offset] = (byte)(value >> 8 * i & 0xFFL);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static GoogleCredential loadCredential(HttpTransport transport, JsonFactory factory, String credentialsPath) throws IOException {
            GoogleCredential credential;
            Logger log = LoggerFactory.getLogger((String)"StackdriverWriter");
            if (credentialsPath != null && !credentialsPath.isEmpty()) {
                try (FileInputStream stream = new FileInputStream(credentialsPath);){
                    credential = GoogleCredential.fromStream((InputStream)stream, (HttpTransport)transport, (JsonFactory)factory).createScoped(Collections.singleton("https://www.googleapis.com/auth/monitoring"));
                    log.info("Loaded credentials from from {}", (Object)credentialsPath);
                }
            } else {
                log.info("spectator.stackdriver.monitoring.enabled without spectator.stackdriver.credentialsPath.  Using default application credentials.");
                credential = GoogleCredential.getApplicationDefault();
            }
            return credential;
        }
    }
}

