/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.stackdriver;

import com.google.api.services.monitoring.v3.Monitoring;
import com.google.api.services.monitoring.v3.model.LabelDescriptor;
import com.google.api.services.monitoring.v3.model.MetricDescriptor;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.stackdriver.ConfigParams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricDescriptorCache {
    public static final String INSTANCE_LABEL = "InstanceSrc";
    private final Monitoring service;
    private final String projectResourceName;
    private final Logger log = LoggerFactory.getLogger((String)"StackdriverMdCache");
    private String baseStackdriverMetricTypeName;
    protected Map<String, String> extraTimeSeriesLabels = new HashMap<String, String>();
    private Map<Id, Boolean> idToTimer = new HashMap<Id, Boolean>();
    private Map<String, String> typeToKind = new HashMap<String, String>();

    public MetricDescriptorCache(ConfigParams configParams) {
        this.service = configParams.getStackdriverStub();
        this.projectResourceName = "projects/" + configParams.getProjectName();
        this.baseStackdriverMetricTypeName = String.format("custom.googleapis.com/%s/%s/", configParams.getCustomTypeNamespace(), configParams.getApplicationName());
    }

    public String idToDescriptorType(Id id) {
        return this.baseStackdriverMetricTypeName + id.name();
    }

    public Map<String, String> getExtraTimeSeriesLabels() {
        return this.extraTimeSeriesLabels;
    }

    public void addExtraTimeSeriesLabel(String key, String value) {
        this.extraTimeSeriesLabels.put(key, value);
    }

    public String meterToKind(Registry registry, Meter meter) {
        if (meter instanceof Counter) {
            return "CUMULATIVE";
        }
        if (registry.counters().anyMatch(m -> m.id().equals(meter.id()))) {
            return "CUMULATIVE";
        }
        if (this.meterIsTimer(registry, meter)) {
            return "CUMULATIVE";
        }
        return "GAUGE";
    }

    public Map<String, String> tagsToTimeSeriesLabels(String descriptorType, Iterable<Tag> tags) {
        HashMap<String, String> labels = new HashMap<String, String>(this.extraTimeSeriesLabels);
        for (Tag tag : tags) {
            labels.put(tag.key(), tag.value());
        }
        return labels;
    }

    private void addSanitizedLabel(MetricDescriptor descriptor, Tag tag, Map<String, String> labels) {
    }

    public boolean meterIsTimer(Registry registry, Meter meter) {
        return this.idToTimer.computeIfAbsent(meter.id(), k -> {
            try {
                return registry.timers().anyMatch(m -> m.id().equals(meter.id()));
            }
            catch (ArrayIndexOutOfBoundsException aoex) {
                return meter instanceof Timer;
            }
        });
    }

    public String descriptorTypeToKind(String descriptorType, Registry registry, Meter meter) {
        return this.typeToKind.computeIfAbsent(descriptorType, k -> this.meterToKind(registry, meter));
    }

    public MetricDescriptor addLabel(String descriptorType, String newLabel) {
        MetricDescriptor descriptor;
        String descriptorName = this.projectResourceName + "/metricDescriptors/" + descriptorType;
        this.log.info("Adding label '{}' to stackdriver descriptor '{}'. This may lose existing metric data", (Object)newLabel, (Object)descriptorName);
        try {
            descriptor = (MetricDescriptor)this.service.projects().metricDescriptors().get(descriptorName).execute();
        }
        catch (IOException ioex) {
            this.log.error("Could not fetch descriptor " + descriptorType + ": " + String.valueOf(ioex));
            return null;
        }
        ArrayList labels = descriptor.getLabels();
        if (labels == null) {
            labels = new ArrayList();
            descriptor.setLabels(labels);
        }
        for (LabelDescriptor labelDescriptor : descriptor.getLabels()) {
            if (!labelDescriptor.getKey().equals(newLabel)) continue;
            this.log.info("{} already added to descriptor", (Object)newLabel);
            return descriptor;
        }
        LabelDescriptor labelDescriptor = new LabelDescriptor();
        labelDescriptor.setKey(newLabel);
        labelDescriptor.setValueType("STRING");
        descriptor.getLabels().add(labelDescriptor);
        try {
            this.log.info("Deleting existing stackdriver descriptor {}", (Object)descriptorName);
            this.service.projects().metricDescriptors().delete(descriptorName).execute();
        }
        catch (IOException ioex) {
            this.log.info("Ignoring error " + String.valueOf(ioex));
        }
        try {
            this.log.info("Adding new descriptor for {}", (Object)descriptorName);
            return (MetricDescriptor)this.service.projects().metricDescriptors().create(this.projectResourceName, descriptor).execute();
        }
        catch (IOException ioex) {
            this.log.error("Failed to update the descriptor definition: " + String.valueOf(ioex));
            return null;
        }
    }
}

