/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.controllers.filter.PrototypeMeasurementFilter;
import com.netflix.spectator.stackdriver.ConfigParams;
import com.netflix.spectator.stackdriver.StackdriverWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

@Configuration
@EnableConfigurationProperties(value={SpectatorStackdriverConfigurationProperties.class})
@ConditionalOnProperty(value={"spectator.stackdriver.enabled"})
public class StackdriverConfig {
    @Autowired
    ServerProperties serverProperties;
    private StackdriverWriter stackdriver;

    @Bean
    public StackdriverWriter defaultStackdriverWriter(Environment environment, Registry registry, SpectatorStackdriverConfigurationProperties spectatorStackdriverConfigurationProperties) throws IOException {
        Predicate<Object> measurementFilter;
        Logger log = LoggerFactory.getLogger((String)"StackdriverConfig");
        log.info("Creating StackdriverWriter.");
        Predicate<Measurement> filterNotSpring = new Predicate<Measurement>(){

            @Override
            public boolean test(Measurement measurement) {
                return measurement.id().tags().iterator().hasNext();
            }
        };
        String prototypeFilterPath = spectatorStackdriverConfigurationProperties.getWebEndpoint().getPrototypeFilter().getPath();
        if (!prototypeFilterPath.isEmpty()) {
            log.error("Ignoring prototypeFilterPath because it is not yet supported.");
            measurementFilter = null;
            log.info("Configuring stackdriver filter from {}", (Object)prototypeFilterPath);
            measurementFilter = PrototypeMeasurementFilter.loadFromPath((String)prototypeFilterPath).and((Predicate)filterNotSpring);
        } else {
            measurementFilter = filterNotSpring;
        }
        InetAddress hostaddr = this.serverProperties.getAddress();
        if (hostaddr.equals(InetAddress.getLoopbackAddress())) {
            hostaddr = InetAddress.getLocalHost();
        }
        String host = hostaddr.getCanonicalHostName();
        String hostPort = host + ":" + this.serverProperties.getPort();
        ConfigParams params = new ConfigParams.Builder().setCounterStartTime(new Date().getTime()).setCustomTypeNamespace("spinnaker").setProjectName(spectatorStackdriverConfigurationProperties.getStackdriver().getProjectName()).setApplicationName(spectatorStackdriverConfigurationProperties.getApplicationName(environment.getProperty("spring.application.name"))).setCredentialsPath(spectatorStackdriverConfigurationProperties.getStackdriver().getCredentialsPath()).setMeasurementFilter(measurementFilter).setInstanceId(hostPort).build();
        this.stackdriver = new StackdriverWriter(params);
        Scheduler scheduler = Schedulers.from((Executor)Executors.newFixedThreadPool(1));
        Observable.timer((long)spectatorStackdriverConfigurationProperties.getStackdriver().getPeriod(), (TimeUnit)TimeUnit.SECONDS).repeat().subscribe(interval -> this.stackdriver.writeRegistry(registry));
        return this.stackdriver;
    }

    @ConfigurationProperties(value="spectator")
    public static class SpectatorStackdriverConfigurationProperties {
        private String applicationName;
        @NestedConfigurationProperty
        private StackdriverProperties stackdriver = new StackdriverProperties();
        @NestedConfigurationProperty
        private WebEndpointProperties webEndpoint = new WebEndpointProperties();

        public String getApplicationName(String defaultValue) {
            if (this.applicationName == null || this.applicationName.isEmpty()) {
                return defaultValue;
            }
            return this.applicationName;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public StackdriverProperties getStackdriver() {
            return this.stackdriver;
        }

        public void setStackdriver(StackdriverProperties stackdriver) {
            this.stackdriver = stackdriver;
        }

        public WebEndpointProperties getWebEndpoint() {
            return this.webEndpoint;
        }

        public void setWebEndpoint(WebEndpointProperties webEndpoint) {
            this.webEndpoint = webEndpoint;
        }

        public static class StackdriverProperties {
            private String credentialsPath = "";
            private String projectName = "";
            private int period = 60;

            public String getCredentialsPath() {
                return this.credentialsPath;
            }

            public void setCredentialsPath(String credentialsPath) {
                this.credentialsPath = credentialsPath;
            }

            public String getProjectName() {
                return this.projectName;
            }

            public void setProjectName(String projectName) {
                this.projectName = projectName;
            }

            public int getPeriod() {
                return this.period;
            }

            public void setPeriod(int period) {
                this.period = period;
            }
        }

        public static class WebEndpointProperties {
            @NestedConfigurationProperty
            private PrototypeFilterPath prototypeFilter = new PrototypeFilterPath();

            public PrototypeFilterPath getPrototypeFilter() {
                return this.prototypeFilter;
            }

            public void setPrototypeFilter(PrototypeFilterPath prototypeFilter) {
                this.prototypeFilter = prototypeFilter;
            }

            public static class PrototypeFilterPath {
                private String path = "";

                public String getPath() {
                    return this.path;
                }

                public void setPath(String path) {
                    this.path = path;
                }
            }
        }
    }
}

