/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.paths.AbstractPathProvider;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@Configuration
@ConditionalOnProperty(value={"swagger.enabled"})
@ConfigurationProperties(prefix="swagger")
public class SwaggerConfig {
    private String title;
    private String description;
    private String contact;
    private List<String> patterns;
    private String basePath = "";
    private String documentationPath = "/";
    private static final ImmutableList<String> IGNORED_CLASS_NAMES = ImmutableList.of((Object)"groovy.lang.MetaClass");

    @Bean
    public Docket gateApi() {
        return new Docket(DocumentationType.SWAGGER_2).pathProvider((PathProvider)new BasePathProvider(this.basePath, this.documentationPath)).select().apis(RequestHandlerSelectors.any()).paths(this.paths()).build().apiInfo(this.apiInfo()).ignoredParameterTypes(SwaggerConfig.ignoredClasses());
    }

    private static Class[] ignoredClasses() {
        return (Class[])IGNORED_CLASS_NAMES.stream().map(SwaggerConfig::getClassIfPresent).filter(Objects::nonNull).toArray(Class[]::new);
    }

    @Nullable
    private static Class<?> getClassIfPresent(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Predicate<String> paths() {
        return Predicates.or((Iterable)this.patterns.stream().map(PathSelectors::regex).collect(Collectors.toList()));
    }

    private ApiInfo apiInfo() {
        return new ApiInfo(this.title, this.description, null, null, this.contact, null, null);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setDocumentationPath(String documentationPath) {
        this.documentationPath = documentationPath;
    }

    public String getDocumentationPath() {
        return this.documentationPath;
    }

    public class BasePathProvider
    extends AbstractPathProvider {
        private String basePath;
        private String documentationPath;

        private BasePathProvider(String basePath, String documentationPath) {
            this.basePath = basePath;
            this.documentationPath = documentationPath;
        }

        protected String applicationPath() {
            return this.basePath;
        }

        protected String getDocumentationPath() {
            return this.documentationPath;
        }
    }
}

