/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.springdoc.core.SpringDocUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"swagger.enabled"})
@ConfigurationProperties(prefix="swagger")
public class SwaggerConfig {
    private String title;
    private String description;
    private String contact;
    private List<String> patterns;
    private String basePath = "";
    private String documentationPath = "/";
    private static final List<String> IGNORED_CLASS_NAMES = List.of("groovy.lang.MetaClass");

    @Bean
    public OpenAPI gateApi() {
        Arrays.stream(SwaggerConfig.ignoredClasses()).forEach(each -> SpringDocUtils.getConfig().addJavaTypeToIgnore(each));
        return new OpenAPI().info(new Info().description(this.description).title(this.title).contact(new Contact().name(this.contact))).externalDocs(new ExternalDocumentation().url("https://spinnaker.io").description("Spinnaker Documentation"));
    }

    private static Class[] ignoredClasses() {
        return (Class[])IGNORED_CLASS_NAMES.stream().map(SwaggerConfig::getClassIfPresent).filter(Objects::nonNull).toArray(Class[]::new);
    }

    @Nullable
    private static Class<?> getClassIfPresent(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setDocumentationPath(String documentationPath) {
        this.documentationPath = documentationPath;
    }

    public String getDocumentationPath() {
        return this.documentationPath;
    }
}

