/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.telemetry;

import com.google.common.base.Strings;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spinnaker.kork.annotations.Metered;
import com.netflix.spinnaker.kork.telemetry.MethodInstrumentation;
import com.netflix.spinnaker.kork.telemetry.MetricTags;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class InstrumentedProxy
implements InvocationHandler {
    private static final String INVOCATIONS = "invocations";
    private static final String TIMING = "timing";
    private final Registry registry;
    private final Object target;
    private final String metricNamespace;
    private final Map<String, String> tags;
    private final Map<Method, MethodMetrics> instrumentedMethods = new ConcurrentHashMap<Method, MethodMetrics>();
    private final List<Method> seenMethods = new ArrayList<Method>();

    public static <T> T proxy(Registry registry, Object target, String metricNamespace) {
        return InstrumentedProxy.proxy(registry, target, metricNamespace, new HashMap<String, String>());
    }

    public static <T> T proxy(Registry registry, Object target, String metricNamespace, Map<String, String> tags) {
        LinkedHashSet interfaces = new LinkedHashSet();
        InstrumentedProxy.addHierarchy(interfaces, target.getClass());
        Class[] proxyInterfaces = (Class[])interfaces.stream().filter(Class::isInterface).toArray(Class[]::new);
        return (T)Proxy.newProxyInstance(target.getClass().getClassLoader(), proxyInterfaces, (InvocationHandler)new InstrumentedProxy(registry, target, metricNamespace, tags));
    }

    public InstrumentedProxy(Registry registry, Object target, String metricNamespace) {
        this(registry, target, metricNamespace, new HashMap<String, String>());
    }

    public InstrumentedProxy(Registry registry, Object target, String metricNamespace, Map<String, String> tags) {
        this.registry = registry;
        this.target = target;
        this.metricNamespace = metricNamespace;
        this.tags = tags;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodMetrics methodMetrics = this.getMethodMetrics(method);
        MetricTags.ResultValue resultValue = MetricTags.ResultValue.FAILURE;
        long start = System.currentTimeMillis();
        try {
            Object result = method.invoke(this.target, args);
            resultValue = MetricTags.ResultValue.SUCCESS;
            Object object = result;
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            if (methodMetrics != null) {
                this.registry.counter(methodMetrics.invocationsId.withTag("result", resultValue.toString())).increment();
                this.recordTiming(methodMetrics.timingId.withTag("result", resultValue.toString()), start);
            }
        }
    }

    private void recordTiming(Id id, long startTimeMs) {
        PercentileTimer.get((Registry)this.registry, (Id)id).record(System.currentTimeMillis() - startTimeMs, TimeUnit.MILLISECONDS);
    }

    private Id invocationId(Method method, Map<String, String> tags) {
        return this.registry.createId(MethodInstrumentation.toMetricId(this.metricNamespace, method, INVOCATIONS), tags);
    }

    private Id invocationId(String methodOverride, Map<String, String> tags) {
        return this.registry.createId(MethodInstrumentation.toMetricId(methodOverride, this.metricNamespace, INVOCATIONS), tags);
    }

    private Id timingId(Method method, Map<String, String> tags) {
        return this.registry.createId(MethodInstrumentation.toMetricId(this.metricNamespace, method, TIMING), tags);
    }

    private Id timingId(String methodOverride, Map<String, String> tags) {
        return this.registry.createId(MethodInstrumentation.toMetricId(methodOverride, this.metricNamespace, TIMING), tags);
    }

    private MethodMetrics getMethodMetrics(Method method) {
        if (!this.instrumentedMethods.containsKey(method) && !this.seenMethods.contains(method)) {
            this.seenMethods.add(method);
            boolean processed = false;
            for (Annotation a : method.getDeclaredAnnotations()) {
                if (!(a instanceof Metered)) continue;
                processed = true;
                Metered metered = (Metered)a;
                if (metered.ignore()) {
                    return null;
                }
                Map<String, String> methodTags = MethodInstrumentation.coalesceTags(this.target, method, this.tags, metered.tags());
                if (Strings.isNullOrEmpty((String)metered.metricName())) {
                    this.addInstrumentedMethod(this.instrumentedMethods, method, new MethodMetrics(this.timingId(method, methodTags), this.invocationId(method, methodTags)));
                    continue;
                }
                this.addInstrumentedMethod(this.instrumentedMethods, method, new MethodMetrics(this.timingId(metered.metricName(), methodTags), this.invocationId(metered.metricName(), methodTags)));
            }
            if (!processed && !this.instrumentedMethods.containsKey(method)) {
                this.addInstrumentedMethod(this.instrumentedMethods, method, new MethodMetrics(this.timingId(method, this.tags), this.invocationId(method, this.tags)));
            }
        }
        return this.instrumentedMethods.get(method);
    }

    private void addInstrumentedMethod(Map<Method, MethodMetrics> existingMethodMetrics, Method method, MethodMetrics methodMetrics) {
        if (!MethodInstrumentation.isMethodAllowed(method)) {
            return;
        }
        existingMethodMetrics.putIfAbsent(method, methodMetrics);
    }

    private static void addHierarchy(Set<Class<?>> classes, Class<?> cl) {
        if (cl == null) {
            return;
        }
        if (classes.add(cl)) {
            for (Class<?> iface : cl.getInterfaces()) {
                InstrumentedProxy.addHierarchy(classes, iface);
            }
            Class<?> superclass = cl.getSuperclass();
            if (superclass != null) {
                InstrumentedProxy.addHierarchy(classes, superclass);
            }
        }
    }

    private static class MethodMetrics {
        final Id timingId;
        final Id invocationsId;

        MethodMetrics(Id timingId, Id invocationsId) {
            this.timingId = timingId;
            this.invocationsId = invocationsId;
        }
    }
}

