/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.telemetry;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MethodInstrumentation {
    public static boolean isMethodAllowed(Method method) {
        return Modifier.isPublic(method.getModifiers()) && Arrays.stream(Object.class.getDeclaredMethods()).noneMatch(m -> m.getName().equals(method.getName()));
    }

    public static String toMetricId(String metricNamespace, Method method, String metricName) {
        String methodName = method.getParameterCount() == 0 ? method.getName() : String.format("%s%d", method.getName(), method.getParameterCount());
        return MethodInstrumentation.toMetricId(metricNamespace, methodName, metricName);
    }

    public static String toMetricId(String metricNamespace, String methodName, String metricName) {
        return String.format("%s.%s.%s", metricNamespace, methodName, metricName);
    }

    public static Map<String, String> coalesceTags(Object target, Method method, Map<String, String> defaultTags, String[] methodTags) {
        if (methodTags.length % 2 != 0) {
            throw new UnevenTagSequenceException(target, method.toGenericString());
        }
        HashMap<String, String> result = new HashMap<String, String>(defaultTags);
        for (int i = 0; i < methodTags.length; i += 2) {
            result.put(methodTags[i], methodTags[i + 1]);
        }
        return result;
    }

    public static class MetricNameCollisionException
    extends IllegalStateException {
        public MetricNameCollisionException(Object target, String metricName, Method method1, Method method2) {
            super(String.format("Metric name (%s) collision detected between methods '%s' and '%s' in '%s'", metricName, method1.toGenericString(), method2.toGenericString(), target.getClass().getSimpleName()));
        }
    }

    private static class UnevenTagSequenceException
    extends IllegalStateException {
        public UnevenTagSequenceException(Object target, String method) {
            super(String.format("There are an uneven number of values provided for tags on method '%s' in '%s'", method, target.getClass().getSimpleName()));
        }
    }
}

