/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.telemetry.caffeine;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import java.util.concurrent.TimeUnit;

public class CaffeineStatsCounter
implements StatsCounter {
    private final Counter hitCount;
    private final Counter missCount;
    private final Counter loadSuccessCount;
    private final Counter loadFailureCount;
    private final Timer totalLoadTime;
    private final Counter evictionCount;
    private final Counter evictionWeight;

    public CaffeineStatsCounter(Registry registry, String metricsPrefix) {
        this.hitCount = registry.counter(metricsPrefix + ".hits");
        this.missCount = registry.counter(metricsPrefix + ".misses");
        this.totalLoadTime = registry.timer(metricsPrefix + ".loads");
        this.loadSuccessCount = registry.counter(metricsPrefix + ".loads-success");
        this.loadFailureCount = registry.counter(metricsPrefix + ".loads-failure");
        this.evictionCount = registry.counter(metricsPrefix + ".evictions");
        this.evictionWeight = registry.counter(metricsPrefix + ".evictions-weight");
    }

    public void recordHits(int count) {
        this.hitCount.increment((long)count);
    }

    public void recordMisses(int count) {
        this.missCount.increment((long)count);
    }

    public void recordLoadSuccess(long loadTime) {
        this.loadSuccessCount.increment();
        this.totalLoadTime.record(loadTime, TimeUnit.NANOSECONDS);
    }

    public void recordLoadFailure(long loadTime) {
        this.loadFailureCount.increment();
        this.totalLoadTime.record(loadTime, TimeUnit.NANOSECONDS);
    }

    public void recordEviction() {
        this.recordEviction(1);
    }

    public void recordEviction(int weight) {
        this.evictionCount.increment();
        this.evictionWeight.increment((long)weight);
    }

    public CacheStats snapshot() {
        return new CacheStats(this.hitCount.count(), this.missCount.count(), this.loadSuccessCount.count(), this.loadFailureCount.count(), this.totalLoadTime.count(), this.evictionCount.count(), this.evictionWeight.count());
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

