/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.test.mimicker.producers.aws;

import com.netflix.spinnaker.kork.test.mimicker.producers.RandomProducer;
import com.netflix.spinnaker.kork.test.mimicker.producers.TextProducer;
import com.netflix.spinnaker.kork.test.mimicker.producers.aws.AwsProducer;
import java.util.Arrays;
import java.util.regex.Pattern;

public class AwsArnProducer {
    private static final String PARTITION = "{{PARTITION}}";
    private static final String REGION = "{{REGION}}";
    private static final String ACCOUNT = "{{ACCOUNT}}";
    private static final String UUID = "{{UUID}}";
    private static final String DASHED_ID = "{{DASHED_ID}}";
    private static final String AWS_ID = "{{AWS_ID}}";
    private final AwsProducer awsProducer;
    private final TextProducer textProducer;
    private final RandomProducer randomProducer;

    public AwsArnProducer(AwsProducer awsProducer, TextProducer textProducer, RandomProducer randomProducer) {
        this.awsProducer = awsProducer;
        this.textProducer = textProducer;
        this.randomProducer = randomProducer;
    }

    private String render(String template) {
        return template.replaceAll(Pattern.quote(PARTITION), this.getPartition()).replaceAll(Pattern.quote(REGION), this.awsProducer.getRegion()).replaceAll(Pattern.quote(ACCOUNT), this.awsProducer.getAccountId()).replaceAll(Pattern.quote(UUID), this.randomProducer.uuid()).replaceAll(Pattern.quote(DASHED_ID), this.textProducer.dashedWords(1, 6)).replaceAll(Pattern.quote(AWS_ID), this.randomProducer.numeric(17));
    }

    public String getPartition() {
        return this.randomProducer.element(Arrays.asList("aws", "aws-cn", "aws-us-gov"));
    }

    public String getAutoscalingPolicy() {
        return this.render("arn:{{PARTITION}}:autoscaling:{{REGION}}:{{ACCOUNT}}:scalingPolicy:{{UUID}}:autoScalingGroupName/{{DASHED_ID}}:policyName/{{DASHED_ID}}");
    }

    public class Ec2Arns {
        public String getInstance() {
            return AwsArnProducer.this.render("arn:{{PARTITION}}:ec2:{{REGION}}:{{ACCOUNT}}:instance/{{AWS_ID}}");
        }
    }
}

