/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.test.time;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalAmount;

public class MutableClock
extends Clock {
    private Instant instant;
    private final ZoneId zone;

    public MutableClock(Instant instant, ZoneId zone) {
        this.instant = instant;
        this.zone = zone;
    }

    public MutableClock(Instant instant) {
        this(instant, ZoneId.systemDefault());
    }

    public MutableClock(ZoneId zone) {
        this(Instant.now(), zone);
    }

    public MutableClock() {
        this(Instant.now(), ZoneId.systemDefault());
    }

    @Override
    public MutableClock withZone(ZoneId zone) {
        return new MutableClock(this.instant, zone);
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public Instant instant() {
        return this.instant;
    }

    public void incrementBy(TemporalAmount amount) {
        this.instant = this.instant.plus(amount);
    }

    public void instant(Instant newInstant) {
        this.instant = newInstant;
    }
}

