/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.test;

import com.netflix.spinnaker.kork.test.KorkTestException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nonnull;

public class MapUtils {
    @Nonnull
    public static Map<String, Object> merge(@Nonnull Map<String, Object> original, @Nonnull Map<String, Object> override) {
        LinkedHashSet<String> remainingKeys = new LinkedHashSet<String>(override.keySet());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : original.entrySet()) {
            String key = entry.getKey();
            result.put(key, entry.getValue());
            if (override.containsKey(key)) {
                Object value = override.get(key);
                if (value == null) {
                    result.remove(key);
                } else {
                    result.merge(key, value, MapUtils::mergeObject);
                }
            }
            remainingKeys.remove(key);
        }
        for (String newKey : remainingKeys) {
            result.put(newKey, override.get(newKey));
        }
        return result;
    }

    private static Object mergeObject(Object original, Object override) {
        if (original instanceof Map) {
            if (!(override instanceof Map)) {
                throw new IllegalMergeTypeException("Attempt to merge Map with " + override.getClass().getSimpleName());
            }
            return MapUtils.merge(MapUtils.toMap(original), MapUtils.toMap(override));
        }
        if (original instanceof Collection && !(override instanceof Collection)) {
            throw new IllegalMergeTypeException("Attempt to replace Collection with " + override.getClass().getSimpleName());
        }
        return override;
    }

    private static Map<String, Object> toMap(Object o) {
        return (Map)o;
    }

    public static class IllegalMergeTypeException
    extends KorkTestException {
        public IllegalMergeTypeException(String message) {
            super(message);
        }
    }
}

