/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.test.mimicker.producers;

import java.security.SecureRandom;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.jetbrains.annotations.NotNull;

public class RandomProducer {
    private final SecureRandom random;

    public RandomProducer(SecureRandom random) {
        this.random = random;
    }

    public boolean trueOrFalse() {
        return this.random.nextBoolean();
    }

    @NotNull
    public <T> T element(@NotNull List<T> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("list must have at least one value");
        }
        return list.get(this.random.nextInt(list.size()));
    }

    @NotNull
    public String alpha(int boundsMin, int boundsMax) {
        return RandomStringUtils.randomAlphabetic((int)boundsMin, (int)boundsMax);
    }

    @NotNull
    public String alphanumeric(int boundsMin, int boundsMax) {
        return RandomStringUtils.randomAlphanumeric((int)boundsMin, (int)boundsMax);
    }

    @NotNull
    public String alphanumeric(int length) {
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    @NotNull
    public String numeric(int length) {
        return RandomStringUtils.randomNumeric((int)length);
    }

    public int intValue(int boundsMin, int boundsMax) {
        return RandomUtils.nextInt((int)boundsMin, (int)boundsMax);
    }

    public long longValue(long boundsMin, long boundsMax) {
        return RandomUtils.nextLong((long)boundsMin, (long)boundsMax);
    }

    @NotNull
    public String uuid() {
        return UUID.randomUUID().toString();
    }
}

