/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.test.mimicker;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.netflix.spinnaker.kork.test.KorkTestException;
import com.netflix.spinnaker.kork.test.MapUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.yaml.snakeyaml.Yaml;

public class DataContainer {
    private static final Logger log = LoggerFactory.getLogger(DataContainer.class);
    private final SecureRandom random = new SecureRandom();
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
    private final Yaml yaml = new Yaml();
    private final Map<String, Object> data = new HashMap<String, Object>();

    public DataContainer() {
        this.withDefaultResources();
    }

    public DataContainer(List<String> resourcePaths) {
        for (String path : resourcePaths) {
            this.load(path);
        }
    }

    @NotNull
    public DataContainer withDefaultResources() {
        this.load("mimicker.yml");
        return this;
    }

    public DataContainer load(String resourcePath) {
        log.debug("Loading data: {}", (Object)resourcePath);
        ClassPathResource resource = new ClassPathResource(resourcePath);
        try (InputStream is = resource.getInputStream();){
            this.data.putAll(MapUtils.merge(this.data, (Map)this.yaml.load(is)));
        }
        catch (IOException e) {
            throw new KorkTestException(String.format("Failed reading mimic data: %s", resourcePath), e);
        }
        return this;
    }

    @NotNull
    public String get(@NotNull String key) {
        return this.getOfType(key, String.class);
    }

    public boolean exists(@NotNull String key) {
        return !this.objectMapper.valueToTree(this.data).at(this.normalizeKey(key)).isMissingNode();
    }

    @NotNull
    public <T> @NotNull List<@NotNull T> list(@NotNull String key) {
        List value = this.getOfType(key, List.class);
        return value;
    }

    @NotNull
    public String random(@NotNull String key) {
        List candidates = this.getOfType(key, List.class);
        return (String)candidates.get(this.random.nextInt(candidates.size()));
    }

    @NotNull
    public <T> T getOfType(@NotNull String key, Class<T> type) {
        TreeTraversingParser parser = new TreeTraversingParser(this.objectMapper.valueToTree(this.data).at(this.normalizeKey(key)), (ObjectCodec)this.objectMapper);
        try {
            return (T)this.objectMapper.readValue((JsonParser)parser, type);
        }
        catch (IOException e) {
            throw new KorkTestException(String.format("Unable to map '%s' to %s", key, type), e);
        }
    }

    private String normalizeKey(@NotNull String key) {
        if (key.startsWith("/mimicker/")) {
            return key;
        }
        return String.format("/mimicker/%s", key);
    }
}

