/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.test.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.read.ListAppender;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class MemoryAppender
extends ListAppender<ILoggingEvent> {
    private static final Layout<ILoggingEvent> layout = MemoryAppender.getRootLayout();
    private final Logger logger;

    public MemoryAppender(Class loggerClass) {
        this(loggerClass, Level.DEBUG);
    }

    public MemoryAppender(Class loggerClass, Level level) {
        this.logger = (Logger)LoggerFactory.getLogger((Class)Objects.requireNonNull(loggerClass));
        this.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        this.logger.addAppender((Appender)this);
        this.logger.setLevel(level);
        this.start();
    }

    public void reset() {
        this.list.clear();
    }

    public long countEventsForLevel(Level level) {
        return this.list.stream().filter(event -> event.getLevel() == level).count();
    }

    public List<String> layoutSearch(String string, Level level) {
        return this.list.stream().filter(event -> event.getLevel().equals(level)).map(arg_0 -> layout.doLayout(arg_0)).filter(message -> message.contains(string)).collect(Collectors.toList());
    }

    public List<String> search(String string, Level level) {
        return this.list.stream().filter(event -> event.getLevel().equals(level)).map(Object::toString).filter(message -> message.contains(string)).collect(Collectors.toList());
    }

    private static Layout<ILoggingEvent> getRootLayout() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        Iterator appenderIterator = rootLogger.iteratorForAppenders();
        Appender appender = (Appender)appenderIterator.next();
        OutputStreamAppender rootAppender = null;
        if (!(appender instanceof OutputStreamAppender)) {
            throw new IllegalStateException("no root OutputStreamAppender");
        }
        rootAppender = (OutputStreamAppender)appender;
        if (appenderIterator.hasNext()) {
            throw new IllegalStateException("multiple encoders -- can't determine layout");
        }
        if (!(rootAppender.getEncoder() instanceof LayoutWrappingEncoder)) {
            throw new IllegalStateException("no LayoutWrappingEncoder -- can't determine layout");
        }
        LayoutWrappingEncoder rootEncoder = (LayoutWrappingEncoder)rootAppender.getEncoder();
        return rootEncoder.getLayout();
    }
}

