/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.test.mimicker.producers.aws;

import com.netflix.spinnaker.kork.test.mimicker.DataContainer;
import com.netflix.spinnaker.kork.test.mimicker.producers.RandomProducer;
import com.netflix.spinnaker.kork.test.mimicker.producers.TextProducer;
import com.netflix.spinnaker.kork.test.mimicker.producers.aws.AwsArnProducer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AwsProducer {
    private final DataContainer dataContainer;
    private final TextProducer textProducer;
    private final RandomProducer randomProducer;

    public AwsProducer(DataContainer dataContainer, TextProducer textProducer, RandomProducer randomProducer) {
        this.dataContainer = dataContainer;
        this.textProducer = textProducer;
        this.randomProducer = randomProducer;
        dataContainer.load("mimicker-aws.yml");
    }

    @NotNull
    public String getRegion() {
        return this.dataContainer.random("aws/regions");
    }

    @NotNull
    public @NotNull List<@NotNull String> getAvailabilityZones() {
        return this.dataContainer.list(String.format("aws/availabilityZones/%s", this.getRegion()));
    }

    @NotNull
    public @NotNull List<@NotNull String> getAvailabilityZones(String region) {
        return this.dataContainer.list(String.format("aws/availabilityZones/%s", region));
    }

    @NotNull
    public String getAvailabilityZone() {
        return this.randomProducer.element(this.getAvailabilityZones());
    }

    @NotNull
    public String getAvailabilityZone(String region) {
        return this.randomProducer.element(this.getAvailabilityZones(region));
    }

    @NotNull
    public String getIdentifier(String prefix) {
        return this.getIdentifier(prefix, 17);
    }

    @NotNull
    public String getIdentifier(String prefix, int length) {
        return String.format("%s-%s", prefix, this.randomProducer.alphanumeric(length));
    }

    @NotNull
    public String getAmiId() {
        return this.getIdentifier("ami");
    }

    @NotNull
    public String getVpcId() {
        return this.getIdentifier("vpc");
    }

    @NotNull
    public String getSubnetId() {
        return this.getIdentifier("subnet");
    }

    @NotNull
    public String getInstanceId() {
        return this.getIdentifier("i");
    }

    @NotNull
    public String getVolumeId() {
        return this.getIdentifier("vol");
    }

    @NotNull
    public String snapshotId() {
        return this.getIdentifier("snap");
    }

    @NotNull
    public String getEipId() {
        return this.getIdentifier("eipalloc");
    }

    @NotNull
    public String getEniId() {
        return this.getIdentifier("eni");
    }

    @NotNull
    public String getSecurityGroupId() {
        return this.getIdentifier("sg");
    }

    public String getInstanceType() {
        return this.dataContainer.random("mimic.aws.instanceTypes");
    }

    @NotNull
    public String getAccountId() {
        return this.randomProducer.numeric(12);
    }

    public AwsArnProducer getArns() {
        return new AwsArnProducer(this, this.textProducer, this.randomProducer);
    }
}

