/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.tomcat;

import com.netflix.spinnaker.kork.tomcat.TomcatConfigurationProperties;
import com.netflix.spinnaker.kork.tomcat.x509.BlocklistingSSLImplementation;
import com.netflix.spinnaker.kork.tomcat.x509.SslExtensionConfigurationProperties;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.Ssl;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
class DefaultTomcatConnectorCustomizer
implements TomcatConnectorCustomizer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TomcatConfigurationProperties tomcatConfigurationProperties;
    private final SslExtensionConfigurationProperties sslExtensionConfigurationProperties;

    DefaultTomcatConnectorCustomizer(TomcatConfigurationProperties tomcatConfigurationProperties, SslExtensionConfigurationProperties sslExtensionConfigurationProperties) {
        this.tomcatConfigurationProperties = tomcatConfigurationProperties;
        this.sslExtensionConfigurationProperties = sslExtensionConfigurationProperties;
    }

    public void customize(Connector connector) {
        this.applySSLSettings(connector);
        this.applyRelaxedURIProperties(connector);
        if (this.tomcatConfigurationProperties.getRejectIllegalHeader() != null) {
            ((AbstractHttp11Protocol)connector.getProtocolHandler()).setRejectIllegalHeader(this.tomcatConfigurationProperties.getRejectIllegalHeader().booleanValue());
        }
    }

    Ssl copySslConfigurationWithClientAuth(TomcatServletWebServerFactory tomcat) {
        Ssl ssl = new Ssl();
        BeanUtils.copyProperties((Object)tomcat.getSsl(), (Object)ssl);
        ssl.setClientAuth(Ssl.ClientAuth.NEED);
        ssl.setCiphers(this.tomcatConfigurationProperties.getCipherSuites().toArray(new String[this.tomcatConfigurationProperties.getCipherSuites().size()]));
        return ssl;
    }

    void applySSLSettings(Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        if (handler instanceof AbstractHttp11JsseProtocol && ((AbstractHttp11JsseProtocol)handler).isSSLEnabled()) {
            SSLHostConfig[] sslConfigs = connector.findSslHostConfigs();
            if (sslConfigs.length != 1) {
                throw new RuntimeException(String.format("Ssl configs: found %d, expected 1.", sslConfigs.length));
            }
            ((AbstractHttp11JsseProtocol)handler).setSslImplementationName(BlocklistingSSLImplementation.class.getName());
            SSLHostConfig sslHostConfig = sslConfigs[0];
            sslHostConfig.setHonorCipherOrder(true);
            sslHostConfig.setCiphers(String.join((CharSequence)",", this.tomcatConfigurationProperties.getCipherSuites()));
            sslHostConfig.setProtocols(String.join((CharSequence)",", this.tomcatConfigurationProperties.getTlsVersions()));
            sslHostConfig.setCertificateRevocationListFile(this.sslExtensionConfigurationProperties.getCrlFile());
        }
    }

    void applyRelaxedURIProperties(Connector connector) {
        if (StringUtils.isEmpty((Object)this.tomcatConfigurationProperties.getRelaxedPathCharacters()) && StringUtils.isEmpty((Object)this.tomcatConfigurationProperties.getRelaxedQueryCharacters())) {
            return;
        }
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        if (protocolHandler instanceof AbstractHttp11Protocol) {
            if (!StringUtils.isEmpty((Object)this.tomcatConfigurationProperties.getRelaxedPathCharacters())) {
                ((AbstractHttp11Protocol)protocolHandler).setRelaxedPathChars(this.tomcatConfigurationProperties.getRelaxedPathCharacters());
            }
            if (!StringUtils.isEmpty((Object)this.tomcatConfigurationProperties.getRelaxedQueryCharacters())) {
                ((AbstractHttp11Protocol)protocolHandler).setRelaxedPathChars(this.tomcatConfigurationProperties.getRelaxedPathCharacters());
            }
        } else {
            this.log.warn("Can't apply relaxedPath/Query config to connector of type $connector.protocolHandlerClassName");
        }
    }
}

