/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.tomcat.x509;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.kork.tomcat.x509.Blocklist;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.Files;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;

public class ReloadingFileBlocklist
implements Blocklist {
    private static final int DEFAULT_RELOAD_INTERVAL_SECONDS = 5;
    private final String blocklistFile;
    private final LoadingCache<String, Set<Entry>> blocklist;

    public ReloadingFileBlocklist(String blocklistFile, long reloadInterval, TimeUnit unit) {
        this.blocklistFile = blocklistFile;
        this.blocklist = CacheBuilder.newBuilder().expireAfterAccess(reloadInterval, unit).build((CacheLoader)new CacheLoader<String, Set<Entry>>(){

            public Set<Entry> load(String key) throws Exception {
                File f = new File(key);
                if (!f.exists()) {
                    return Collections.emptySet();
                }
                return ImmutableSet.copyOf((Collection)Files.readAllLines(f.toPath()).stream().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).map(x$0 -> Entry.fromString(x$0)).collect(Collectors.toSet()));
            }
        });
    }

    public ReloadingFileBlocklist(String blocklistFile) {
        this(blocklistFile, 5L, TimeUnit.SECONDS);
    }

    @Override
    public boolean isBlocklisted(X509Certificate cert) {
        try {
            return ((Set)this.blocklist.get((Object)this.blocklistFile)).contains(new Entry(cert.getIssuerX500Principal(), cert.getSerialNumber()));
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause != null) {
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            throw new RuntimeException(ee);
        }
    }

    private static class Entry {
        private static final String DELIMITER = ":::";
        private final X500Principal issuer;
        private final BigInteger serial;

        private static Entry fromString(String blocklistEntry) {
            int idx = blocklistEntry.indexOf(DELIMITER);
            if (idx == -1) {
                throw new IllegalArgumentException("Missing delimiter ::: in " + blocklistEntry);
            }
            X500Principal principal = new X500Principal(blocklistEntry.substring(0, idx));
            BigInteger serial = new BigInteger(blocklistEntry.substring(idx + DELIMITER.length()));
            return new Entry(principal, serial);
        }

        private Entry(X500Principal issuer, BigInteger serial) {
            this.issuer = Objects.requireNonNull(issuer);
            this.serial = Objects.requireNonNull(serial);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.issuer.equals(entry.issuer)) {
                return false;
            }
            return this.serial.equals(entry.serial);
        }

        public int hashCode() {
            int result = this.issuer.hashCode();
            result = 31 * result + this.serial.hashCode();
            return result;
        }
    }
}

