/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.tomcat.x509;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.tomcat.x509.Blocklist;
import com.netflix.spinnaker.kork.tomcat.x509.BlocklistingX509TrustManager;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.jsse.JSSEUtil;

public class BlocklistingJSSESocketFactory
extends JSSEUtil {
    private static final String BLOCKLIST_PREFIX = "blocklist:";
    private final Blocklist blocklist;
    private final Registry registry;

    public BlocklistingJSSESocketFactory(SSLHostConfigCertificate certificate, Registry registry) {
        super(certificate);
        this.registry = Objects.requireNonNull(registry);
        String blocklistFile = Optional.ofNullable(certificate.getSSLHostConfig().getCertificateRevocationListFile()).filter(file -> file.startsWith(BLOCKLIST_PREFIX)).map(file -> file.substring(BLOCKLIST_PREFIX.length())).orElse(null);
        if (blocklistFile != null) {
            certificate.getSSLHostConfig().setCertificateRevocationListFile(null);
            this.blocklist = Blocklist.forFile(blocklistFile);
        } else {
            this.blocklist = null;
        }
    }

    public TrustManager[] getTrustManagers() throws Exception {
        TrustManager[] trustManagers = super.getTrustManagers();
        if (this.blocklist != null && trustManagers != null) {
            int delegatedCount = 0;
            for (int i = 0; i < trustManagers.length; ++i) {
                TrustManager tm = trustManagers[i];
                if (!(tm instanceof X509TrustManager)) continue;
                trustManagers[i] = new BlocklistingX509TrustManager((X509TrustManager)tm, this.blocklist, this.registry);
                ++delegatedCount;
            }
            if (delegatedCount != 1) {
                throw new IllegalStateException("expected single X509TrustManager");
            }
        }
        return trustManagers;
    }
}

