/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.tomcat.x509;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.tomcat.x509.Blocklist;
import java.security.cert.CRLReason;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.X509TrustManager;

public class BlocklistingX509TrustManager
implements X509TrustManager {
    public static AtomicBoolean BLOCKLIST_ENABLED = new AtomicBoolean(true);
    private final X509TrustManager delegate;
    private final Blocklist blocklist;
    private final Registry registry;
    private final Id checkClientTrusted;

    public BlocklistingX509TrustManager(X509TrustManager delegate, Blocklist blocklist, Registry registry) {
        this.delegate = Objects.requireNonNull(delegate);
        this.blocklist = Objects.requireNonNull(blocklist);
        this.registry = Objects.requireNonNull(registry);
        this.checkClientTrusted = registry.createId("ssl.blocklist.checkClientTrusted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        if (BLOCKLIST_ENABLED.get()) {
            boolean rejected = false;
            try {
                if (x509Certificates != null) {
                    for (X509Certificate cert : x509Certificates) {
                        if (!this.blocklist.isBlocklisted(cert)) continue;
                        rejected = true;
                        throw new CertificateRevokedException(new Date(), CRLReason.UNSPECIFIED, cert.getIssuerX500Principal(), Collections.emptyMap());
                    }
                }
            }
            finally {
                this.registry.counter(this.checkClientTrusted.withTag("rejected", Boolean.toString(rejected))).increment();
            }
        }
        this.delegate.checkClientTrusted(x509Certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(x509Certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

