/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.tomcat;

import com.netflix.spinnaker.kork.tomcat.DefaultTomcatConnectorCustomizer;
import com.netflix.spinnaker.kork.tomcat.TomcatConfigurationProperties;
import com.netflix.spinnaker.kork.tomcat.x509.SslExtensionConfigurationProperties;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11NioProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={TomcatConfigurationProperties.class, SslExtensionConfigurationProperties.class})
class TomcatConfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    TomcatConfiguration() {
    }

    @Bean
    TomcatConnectorCustomizer defaultTomcatConnectorCustomizer(TomcatConfigurationProperties tomcatConfigurationProperties, SslExtensionConfigurationProperties sslExtensionConfigurationProperties) {
        if (tomcatConfigurationProperties.getRejectIllegalHeader() != null) {
            System.setProperty("server.tomcat.reject-illegal-header", tomcatConfigurationProperties.getRejectIllegalHeader().toString());
        }
        return new DefaultTomcatConnectorCustomizer(tomcatConfigurationProperties, sslExtensionConfigurationProperties);
    }

    @Bean
    @ConditionalOnExpression(value="${server.ssl.enabled:false}")
    WebServerFactoryCustomizer containerCustomizer(final DefaultTomcatConnectorCustomizer defaultTomcatConnectorCustomizer, final TomcatConfigurationProperties tomcatConfigurationProperties) {
        System.setProperty("jdk.tls.rejectClientInitiatedRenegotiation", "true");
        System.setProperty("jdk.tls.ephemeralDHKeySize", "2048");
        return new WebServerFactoryCustomizer(){

            public void customize(WebServerFactory factory) {
                TomcatServletWebServerFactory tomcat = (TomcatServletWebServerFactory)factory;
                tomcat.addConnectorCustomizers(new TomcatConnectorCustomizer[]{defaultTomcatConnectorCustomizer});
                if (tomcatConfigurationProperties.getLegacyServerPort() > 0) {
                    TomcatConfiguration.this.log.info("Creating legacy connector on port {}", (Object)tomcatConfigurationProperties.getLegacyServerPort());
                    Connector httpConnector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
                    httpConnector.setScheme("http");
                    httpConnector.setPort(tomcatConfigurationProperties.getLegacyServerPort());
                    TomcatConfiguration.applyCompressionSettings(httpConnector, tomcat);
                    tomcat.addAdditionalTomcatConnectors(new Connector[]{httpConnector});
                }
                if (tomcatConfigurationProperties.getApiPort() > 0) {
                    TomcatConfiguration.this.log.info("Creating api connector on port {}", (Object)tomcatConfigurationProperties.getApiPort());
                    Connector apiConnector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
                    apiConnector.setScheme("https");
                    apiConnector.setSecure(true);
                    apiConnector.setPort(tomcatConfigurationProperties.getApiPort());
                    TomcatConfiguration.applyCompressionSettings(apiConnector, tomcat);
                    Ssl ssl = defaultTomcatConnectorCustomizer.copySslConfigurationWithClientAuth(tomcat);
                    CustomizableTomcatServletWebServerFactory newFactory = new CustomizableTomcatServletWebServerFactory();
                    BeanUtils.copyProperties((Object)tomcat, (Object)((Object)newFactory));
                    newFactory.setPort(tomcatConfigurationProperties.getApiPort());
                    newFactory.setSsl(ssl);
                    newFactory.customizeSslConnector(apiConnector);
                    defaultTomcatConnectorCustomizer.customize(apiConnector);
                    tomcat.addAdditionalTomcatConnectors(new Connector[]{apiConnector});
                }
            }
        };
    }

    private static void applyCompressionSettings(Connector connector, TomcatServletWebServerFactory tomcat) {
        Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
        if (tomcat.getCompression().getEnabled()) {
            protocol.setCompression("on");
            protocol.setCompressibleMimeType(String.join((CharSequence)",", tomcat.getCompression().getMimeTypes()));
            protocol.setCompressionMinSize((int)tomcat.getCompression().getMinResponseSize().toBytes());
        } else {
            protocol.setCompression("off");
        }
    }

    private static class CustomizableTomcatServletWebServerFactory
    extends TomcatServletWebServerFactory {
        private CustomizableTomcatServletWebServerFactory() {
        }

        void customizeSslConnector(Connector connector) {
            super.customizeConnector(connector);
        }
    }
}

