/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.exceptions;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.netflix.spinnaker.kork.exceptions.HasAdditionalAttributes;
import com.netflix.spinnaker.kork.exceptions.UserException;
import com.netflix.spinnaker.kork.web.exceptions.ExceptionMessageDecorator;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import retrofit.RetrofitError;
import retrofit.client.Header;

@ControllerAdvice
public class GenericExceptionHandlers
extends ResponseEntityExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GenericExceptionHandlers.class);
    private final DefaultErrorAttributes defaultErrorAttributes = new DefaultErrorAttributes();
    private final ExceptionMessageDecorator exceptionMessageDecorator;

    public GenericExceptionHandlers(ExceptionMessageDecorator exceptionMessageDecorator) {
        this.exceptionMessageDecorator = exceptionMessageDecorator;
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public void handleAccessDeniedException(Exception e, HttpServletResponse response, HttpServletRequest request) throws IOException {
        this.storeException(request, response, e);
        response.sendError(HttpStatus.FORBIDDEN.value(), this.exceptionMessageDecorator.decorate(e, "Access is denied"));
    }

    @ExceptionHandler(value={NotFoundException.class})
    public void handleNotFoundException(Exception e, HttpServletResponse response, HttpServletRequest request) throws IOException {
        this.storeException(request, response, e);
        response.sendError(HttpStatus.NOT_FOUND.value(), this.exceptionMessageDecorator.decorate(e, e.getMessage()));
    }

    @ExceptionHandler(value={InvalidRequestException.class, UserException.class, IllegalArgumentException.class})
    public void handleInvalidRequestException(Exception e, HttpServletResponse response, HttpServletRequest request) throws IOException {
        this.storeException(request, response, e);
        response.sendError(HttpStatus.BAD_REQUEST.value(), this.exceptionMessageDecorator.decorate(e, e.getMessage()));
    }

    @ExceptionHandler(value={RetrofitError.class})
    public void handleRetrofitError(RetrofitError e, HttpServletResponse response, HttpServletRequest request) throws IOException {
        if (e.getResponse() != null) {
            HashMap<String, Object> additionalContext = new HashMap<String, Object>();
            additionalContext.put("url", e.getResponse().getUrl());
            Header contentTypeHeader = e.getResponse().getHeaders().stream().filter(h -> h.getName().equalsIgnoreCase("content-type")).findFirst().orElse(null);
            if (contentTypeHeader != null && contentTypeHeader.getValue().toLowerCase().contains("application/json")) {
                additionalContext.put("body", CharStreams.toString((Readable)new InputStreamReader(e.getResponse().getBody().in(), Charsets.UTF_8)));
            }
            RetrofitErrorWrapper retrofitErrorWrapper = new RetrofitErrorWrapper(e.getMessage(), additionalContext);
            this.storeException(request, response, retrofitErrorWrapper);
            response.sendError(e.getResponse().getStatus(), this.exceptionMessageDecorator.decorate(retrofitErrorWrapper, retrofitErrorWrapper.getMessage()));
        } else {
            this.handleException((Exception)e, response, request);
        }
    }

    @ExceptionHandler(value={Exception.class})
    public void handleException(Exception e, HttpServletResponse response, HttpServletRequest request) throws IOException {
        logger.warn("Handled error in generic exception handler", (Throwable)e);
        this.storeException(request, response, e);
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(e.getClass(), ResponseStatus.class);
        if (responseStatus != null) {
            HttpStatus httpStatus = responseStatus.value();
            if (httpStatus.is5xxServerError()) {
                logger.error(httpStatus.getReasonPhrase(), (Throwable)e);
            } else if (httpStatus != HttpStatus.NOT_FOUND) {
                logger.error(httpStatus.getReasonPhrase() + ": " + e.toString());
            }
            String message = e.getMessage();
            if (message == null || message.trim().isEmpty()) {
                message = responseStatus.reason();
            }
            response.sendError(httpStatus.value(), this.exceptionMessageDecorator.decorate(e, message));
        } else {
            logger.error("Internal Server Error", (Throwable)e);
            response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), this.exceptionMessageDecorator.decorate(e, e.getMessage()));
        }
    }

    private void storeException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        this.defaultErrorAttributes.resolveException(request, response, null, ex);
    }

    private static class RetrofitErrorWrapper
    extends RuntimeException
    implements HasAdditionalAttributes {
        private final Map<String, Object> additionalAttributes;

        public RetrofitErrorWrapper(String message, Map<String, Object> additionalAttributes) {
            super(message);
            this.additionalAttributes = additionalAttributes;
        }

        public Map<String, Object> getAdditionalAttributes() {
            return this.additionalAttributes != null ? this.additionalAttributes : Collections.emptyMap();
        }
    }
}

