/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.interceptors;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileDistributionSummary;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spinnaker.kork.web.interceptors.Criticality;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MetricsInterceptor
extends HandlerInterceptorAdapter {
    static final String TIMER_ATTRIBUTE = "Metrics_startTime";
    private final Registry registry;
    private final String metricName;
    private final String contentLengthMetricName;
    private final Set<String> pathVariablesToTag = new HashSet<String>();
    private final Set<String> queryParamsToTag = new HashSet<String>();
    private final Set<String> controllersToExclude = new HashSet<String>();

    @Deprecated
    public MetricsInterceptor(Registry registry, String metricName, Collection<String> pathVariablesToTag, Collection<String> controllersToExclude) {
        this(registry, metricName, pathVariablesToTag, null, controllersToExclude);
    }

    public MetricsInterceptor(Registry registry, String metricName, Collection<String> pathVariablesToTag, Collection<String> queryParamsToTag, Collection<String> controllersToExclude) {
        this.registry = registry;
        this.metricName = metricName;
        this.contentLengthMetricName = String.format("%s.contentLength", metricName);
        if (pathVariablesToTag != null) {
            this.pathVariablesToTag.addAll(pathVariablesToTag);
        }
        if (queryParamsToTag != null) {
            this.queryParamsToTag.addAll(queryParamsToTag);
        }
        if (controllersToExclude != null) {
            this.controllersToExclude.addAll(controllersToExclude);
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute(TIMER_ATTRIBUTE, (Object)this.getNanoTime());
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String controller = handlerMethod.getMethod().getDeclaringClass().getSimpleName();
            if (this.controllersToExclude.contains(controller)) {
                return;
            }
            Integer status = response.getStatus();
            if (ex != null) {
                status = 500;
            }
            Id id = this.registry.createId(this.metricName).withTag("controller", controller).withTag("method", handlerMethod.getMethod().getName()).withTag("status", status.toString().charAt(0) + "xx").withTag("statusCode", status.toString()).withTag("criticality", this.metricCriticality(handlerMethod));
            Map variables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            for (String pathVariable : this.pathVariablesToTag) {
                if (variables.containsKey(pathVariable)) {
                    id = id.withTag(pathVariable, variables.get(pathVariable).toString());
                    continue;
                }
                id = id.withTag(pathVariable, "None");
            }
            for (String queryParamName : this.queryParamsToTag) {
                String parameter = request.getParameter(queryParamName);
                if (parameter != null) {
                    id = id.withTag(queryParamName, parameter);
                    continue;
                }
                id = id.withTag(queryParamName, "None");
            }
            id = ex != null ? id.withTag("success", "false").withTag("cause", ex.getClass().getSimpleName()) : id.withTag("success", "true").withTag("cause", "None");
            PercentileTimer.get((Registry)this.registry, (Id)id).record(this.getNanoTime() - (Long)request.getAttribute(TIMER_ATTRIBUTE), TimeUnit.NANOSECONDS);
            PercentileDistributionSummary.get((Registry)this.registry, (Id)this.registry.createId(this.contentLengthMetricName).withTags(id.tags())).record(request.getContentLengthLong());
        }
    }

    private String metricCriticality(HandlerMethod handlerMethod) {
        if (handlerMethod.hasMethodAnnotation(Criticality.class)) {
            Criticality criticality = (Criticality)handlerMethod.getMethodAnnotation(Criticality.class);
            return criticality.value();
        }
        if (handlerMethod.getMethod().getDeclaringClass().isAnnotationPresent(Criticality.class)) {
            Criticality criticality = handlerMethod.getMethod().getDeclaringClass().getAnnotation(Criticality.class);
            return criticality.value();
        }
        return "unknown";
    }

    protected Long getNanoTime() {
        return System.nanoTime();
    }
}

