/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config.okhttp3;

import brave.http.HttpTracing;
import brave.okhttp3.TracingInterceptor;
import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class RawOkHttpClientFactory {
    public OkHttpClient create(OkHttpClientConfigurationProperties okHttpClientConfigurationProperties, List<Interceptor> interceptors, HttpTracing httpTracing) {
        Dispatcher dispatcher = RawOkHttpClientFactory.zipkinHttpTracingDispatcher(httpTracing);
        dispatcher.setMaxRequests(okHttpClientConfigurationProperties.getMaxRequests());
        dispatcher.setMaxRequestsPerHost(okHttpClientConfigurationProperties.getMaxRequestsPerHost());
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout(okHttpClientConfigurationProperties.getConnectTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout(okHttpClientConfigurationProperties.getReadTimeoutMs(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(okHttpClientConfigurationProperties.getRetryOnConnectionFailure()).dispatcher(dispatcher).addNetworkInterceptor(RawOkHttpClientFactory.zipkinTracingInterceptor(httpTracing)).connectionPool(new ConnectionPool(okHttpClientConfigurationProperties.getConnectionPool().getMaxIdleConnections(), (long)okHttpClientConfigurationProperties.getConnectionPool().getKeepAliveDurationMs(), TimeUnit.MILLISECONDS));
        if (interceptors != null) {
            interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).addInterceptor(arg_0));
        }
        return okHttpClientBuilder.build();
    }

    private static Dispatcher zipkinHttpTracingDispatcher(HttpTracing httpTracing) {
        return new Dispatcher(httpTracing.tracing().currentTraceContext().executorService(new Dispatcher().executorService()));
    }

    private static Interceptor zipkinTracingInterceptor(HttpTracing httpTracing) {
        return TracingInterceptor.create((HttpTracing)httpTracing);
    }
}

