/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.selector;

import com.netflix.spinnaker.kork.web.selector.SelectableService;
import com.netflix.spinnaker.kork.web.selector.ServiceSelector;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ByLocationServiceSelector
implements ServiceSelector {
    private final int priority;
    private final Object service;
    private final Set<String> locations;

    public ByLocationServiceSelector(Object service, Integer priority, Map<String, Object> config) {
        this.service = service;
        this.priority = priority;
        this.locations = new HashSet(((Map)config.get("locations")).values());
    }

    public Object getService() {
        return this.service;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean supports(SelectableService.Criteria criteria) {
        if (criteria.getLocation() == null) {
            return false;
        }
        return this.locations.contains(criteria.getLocation());
    }
}

