/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config.okhttp3;

import brave.Tracing;
import brave.http.HttpTracing;
import com.netflix.spinnaker.config.okhttp3.RawOkHttpClientFactory;
import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OkHttpClientConfigurationProperties.class})
class RawOkHttpClientConfiguration {
    RawOkHttpClientConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpTracing httpTracing() {
        return HttpTracing.newBuilder((Tracing)Tracing.newBuilder().build()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    OkHttpClient okhttp3Client(OkHttpClientConfigurationProperties okHttpClientConfigurationProperties, List<Interceptor> interceptors, HttpTracing httpTracing) {
        return new RawOkHttpClientFactory().create(okHttpClientConfigurationProperties, interceptors, httpTracing);
    }
}

