/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.selector;

import com.netflix.spinnaker.kork.web.selector.ServiceSelector;
import java.util.List;
import org.springframework.util.Assert;

public class SelectableService<T> {
    private final List<ServiceSelector<T>> serviceSelectors;

    public SelectableService(List<ServiceSelector<T>> serviceSelectors) {
        this.serviceSelectors = serviceSelectors;
    }

    public T getService(Criteria criteria) {
        Assert.notNull((Object)criteria);
        return (T)this.serviceSelectors.stream().filter(it -> it.supports(criteria)).sorted((a, b) -> b.getPriority() - a.getPriority()).findFirst().map(ServiceSelector::getService).orElse(this.serviceSelectors.get(0).getService());
    }

    public static class Criteria {
        private String application;
        private String authenticatedUser;
        private String executionType;
        private String executionId;
        private String origin;
        private String location;

        public String getApplication() {
            return this.application;
        }

        public String getAuthenticatedUser() {
            return this.authenticatedUser;
        }

        public String getExecutionType() {
            return this.executionType;
        }

        public String getExecutionId() {
            return this.executionId;
        }

        public String getOrigin() {
            return this.origin;
        }

        public String getLocation() {
            return this.location;
        }

        public Criteria withApplication(String application) {
            this.application = application;
            return this;
        }

        public Criteria withAuthenticatedUser(String user) {
            this.authenticatedUser = user;
            return this;
        }

        public Criteria withOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        public Criteria withExecutionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        public Criteria withExecutionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public Criteria withLocation(String location) {
            this.location = location;
            return this;
        }
    }
}

