/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.selector;

import com.netflix.spinnaker.kork.web.selector.SelectableService;
import com.netflix.spinnaker.kork.web.selector.ServiceSelector;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ByOriginServiceSelector
implements ServiceSelector {
    private final Object service;
    private final int priority;
    private final String origin;
    private final Set<String> executionTypes;

    public ByOriginServiceSelector(Object service, Integer priority, Map<String, Object> config) {
        this.service = service;
        this.priority = priority;
        this.origin = (String)config.get("origin");
        this.executionTypes = config.containsKey("executionTypes") ? new HashSet(((Map)config.get("executionTypes")).values()) : new HashSet<String>(Arrays.asList("pipeline", "orchestration"));
    }

    public Object getService() {
        return this.service;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean supports(SelectableService.Criteria criteria) {
        return this.origin != null && this.origin.equalsIgnoreCase(criteria.getOrigin()) && this.executionTypes.contains(criteria.getExecutionType());
    }
}

