/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.context;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.MDC;
import org.springframework.core.task.AsyncTaskExecutor;

public class MdcCopyingAsyncTaskExecutor
implements AsyncTaskExecutor {
    private final AsyncTaskExecutor delegate;

    public MdcCopyingAsyncTaskExecutor(AsyncTaskExecutor asyncTaskExecutor) {
        this.delegate = Objects.requireNonNull(asyncTaskExecutor);
    }

    private Runnable wrapWithContext(Runnable task) {
        Map contextMap = MDC.getCopyOfContextMap();
        if (contextMap == null) {
            return task;
        }
        return () -> {
            MDC.setContextMap((Map)contextMap);
            task.run();
        };
    }

    private <T> Callable<T> wrapWithContext(Callable<T> callable) {
        Map contextMap = MDC.getCopyOfContextMap();
        if (contextMap == null) {
            return callable;
        }
        return () -> {
            MDC.setContextMap((Map)contextMap);
            return callable.call();
        };
    }

    public void execute(Runnable task) {
        this.delegate.execute(this.wrapWithContext(task));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute(this.wrapWithContext(task), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.wrapWithContext(task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.wrapWithContext(task));
    }
}

