/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config.okhttp3;

import com.google.common.base.Preconditions;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientBuilderProvider;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0x7FFFFFFE)
@Component
public class DefaultOkHttpClientBuilderProvider
implements OkHttpClientBuilderProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultOkHttpClientBuilderProvider.class);
    private final OkHttpClient okHttpClient;
    private final OkHttpClientConfigurationProperties okHttpClientConfigurationProperties;

    @Autowired
    public DefaultOkHttpClientBuilderProvider(OkHttpClient okHttpClient, OkHttpClientConfigurationProperties okHttpClientConfigurationProperties) {
        this.okHttpClient = okHttpClient;
        this.okHttpClientConfigurationProperties = okHttpClientConfigurationProperties;
    }

    @Override
    public OkHttpClient.Builder get(ServiceEndpoint service) {
        OkHttpClient.Builder builder = this.okHttpClient.newBuilder();
        this.setSSLSocketFactory(builder, service);
        this.applyConnectionSpecs(builder);
        return builder;
    }

    protected OkHttpClient.Builder setSSLSocketFactory(OkHttpClient.Builder builder, ServiceEndpoint serviceEndpoint) {
        if (this.okHttpClientConfigurationProperties.getKeyStore() == null && this.okHttpClientConfigurationProperties.getTrustStore() == null || serviceEndpoint.isUseDefaultSslSocketFactory()) {
            return builder;
        }
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(this.okHttpClientConfigurationProperties.getKeyStoreType());
            ks.load(new FileInputStream(this.okHttpClientConfigurationProperties.getKeyStore()), this.okHttpClientConfigurationProperties.getKeyStorePassword().toCharArray());
            keyManagerFactory.init(ks, this.okHttpClientConfigurationProperties.getKeyStorePassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ts = KeyStore.getInstance(this.okHttpClientConfigurationProperties.getTrustStoreType());
            ts.load(new FileInputStream(this.okHttpClientConfigurationProperties.getTrustStore()), this.okHttpClientConfigurationProperties.getTrustStorePassword().toCharArray());
            trustManagerFactory.init(ts);
            SecureRandom secureRandom = SecureRandom.getInstance(this.okHttpClientConfigurationProperties.getSecureRandomInstanceType());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), secureRandom);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            Preconditions.checkState((trustManagers.length == 1 ? 1 : 0) != 0, (Object)"Found multiple trust managers; don't know which one to use");
            Preconditions.checkState((boolean)(trustManagers[0] instanceof X509TrustManager), (String)"Configured TrustManager is a %s, not an X509TrustManager; don't know how to configure it", (Object)trustManagers[0].getClass().getSimpleName());
            builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]);
        }
        catch (Exception e) {
            log.error("Unable to set ssl socket factory for {}", (Object)serviceEndpoint.getBaseUrl(), (Object)e);
            throw new SystemException(String.format("Unable to set ssl socket factory for (%s)", serviceEndpoint.getBaseUrl()), (Throwable)e);
        }
        return builder;
    }

    protected OkHttpClient.Builder applyConnectionSpecs(OkHttpClient.Builder builder) {
        ConnectionSpec.Builder connectionSpecBuilder = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS);
        if (this.okHttpClientConfigurationProperties.getCipherSuites() != null) {
            connectionSpecBuilder.cipherSuites(this.okHttpClientConfigurationProperties.getCipherSuites().toArray(new String[0]));
        } else {
            connectionSpecBuilder.cipherSuites((String[])Objects.requireNonNull(ConnectionSpec.MODERN_TLS.cipherSuites()).stream().map(CipherSuite::javaName).toArray(String[]::new));
        }
        if (this.okHttpClientConfigurationProperties.getTlsVersions() != null) {
            connectionSpecBuilder.tlsVersions(this.okHttpClientConfigurationProperties.getTlsVersions().toArray(new String[0]));
        } else {
            connectionSpecBuilder.tlsVersions((String[])Objects.requireNonNull(ConnectionSpec.MODERN_TLS.tlsVersions()).stream().map(TlsVersion::javaName).toArray(String[]::new));
        }
        ConnectionSpec connectionSpec = connectionSpecBuilder.build();
        return builder.connectionSpecs(Arrays.asList(connectionSpec, ConnectionSpec.CLEARTEXT));
    }
}

