/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.exceptions;

import com.netflix.spinnaker.kork.api.exceptions.ExceptionDetails;
import com.netflix.spinnaker.kork.api.exceptions.ExceptionMessage;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.ObjectProvider;

public class ExceptionMessageDecorator {
    private final ObjectProvider<List<ExceptionMessage>> exceptionMessagesProvider;
    private final String NEWLINE = "\n\n";

    public ExceptionMessageDecorator(ObjectProvider<List<ExceptionMessage>> exceptionMessagesProvider) {
        this.exceptionMessagesProvider = exceptionMessagesProvider;
    }

    public String decorate(Throwable throwable, String message, @Nullable ExceptionDetails exceptionDetails) {
        return this.decorate(throwable, null, message, exceptionDetails);
    }

    public String decorate(String errorCode, String message, @Nullable ExceptionDetails exceptionDetails) {
        return this.decorate(null, errorCode, message, exceptionDetails);
    }

    public String decorate(Throwable throwable, String message) {
        return this.decorate(throwable, message, null);
    }

    public String decorate(String errorCode, String message) {
        return this.decorate(errorCode, message, null);
    }

    private String decorate(@Nullable Throwable throwable, @Nullable String errorCode, String message, @Nullable ExceptionDetails exceptionDetails) {
        StringBuilder sb = new StringBuilder().append(message);
        List exceptionMessages = (List)this.exceptionMessagesProvider.getIfAvailable();
        if (exceptionMessages != null && !exceptionMessages.isEmpty()) {
            for (ExceptionMessage exceptionMessage : exceptionMessages) {
                if (throwable != null) {
                    exceptionMessage.message(throwable, exceptionDetails).ifPresent(s -> sb.append("\n\n").append((String)s));
                }
                if (errorCode == null) continue;
                exceptionMessage.message(errorCode, exceptionDetails).ifPresent(s -> sb.append("\n\n").append((String)s));
            }
        }
        return sb.toString();
    }
}

