/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.selector;

import com.netflix.spinnaker.kork.web.selector.SelectableService;
import com.netflix.spinnaker.kork.web.selector.ServiceSelector;
import java.util.Map;
import java.util.regex.Pattern;

public class ByAccountServiceSelector
implements ServiceSelector {
    private final Object service;
    private final int priority;
    private final Pattern accountPattern;

    public ByAccountServiceSelector(Object service, Integer priority, Map<String, Object> config) {
        this.service = service;
        this.priority = priority;
        this.accountPattern = Pattern.compile((String)config.get("accountPattern"));
    }

    public Object getService() {
        return this.service;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean supports(SelectableService.Criteria criteria) {
        if (criteria.getAccount() == null) {
            return false;
        }
        return this.accountPattern.matcher(criteria.getAccount().toLowerCase()).matches();
    }
}

