/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.selector;

import com.netflix.spinnaker.kork.web.selector.ServiceSelector;
import java.util.List;
import org.springframework.util.Assert;

public class SelectableService<T> {
    private final List<ServiceSelector<T>> serviceSelectors;

    public SelectableService(List<ServiceSelector<T>> serviceSelectors) {
        this.serviceSelectors = serviceSelectors;
    }

    public T getService(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Criteria is required to select a service");
        return (T)this.serviceSelectors.stream().filter(it -> it.supports(criteria)).min((a, b) -> b.getPriority() - a.getPriority()).map(ServiceSelector::getService).orElse(this.serviceSelectors.get(0).getService());
    }

    public static class Criteria {
        private String account;
        private String application;
        private String authenticatedUser;
        private String cloudProvider;
        private String executionType;
        private String executionId;
        private String origin;
        private String location;

        public String getAccount() {
            return this.account;
        }

        public String getApplication() {
            return this.application;
        }

        public String getAuthenticatedUser() {
            return this.authenticatedUser;
        }

        public String getCloudProvider() {
            return this.cloudProvider;
        }

        public String getExecutionType() {
            return this.executionType;
        }

        public String getExecutionId() {
            return this.executionId;
        }

        public String getOrigin() {
            return this.origin;
        }

        public String getLocation() {
            return this.location;
        }

        public Criteria withAccount(String account) {
            this.account = account;
            return this;
        }

        public Criteria withApplication(String application) {
            this.application = application;
            return this;
        }

        public Criteria withAuthenticatedUser(String user) {
            this.authenticatedUser = user;
            return this;
        }

        public Criteria withCloudProvider(String cloudProvider) {
            this.cloudProvider = cloudProvider;
            return this;
        }

        public Criteria withOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        public Criteria withExecutionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        public Criteria withExecutionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public Criteria withLocation(String location) {
            this.location = location;
            return this;
        }
    }
}

