/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

@ControllerAdvice
@Order(value=10000)
public class BinderControllerAdvice {
    @InitBinder
    public void setAllowedFields(WebDataBinder dataBinder) {
        Set disallowedFields = Optional.ofNullable(dataBinder.getDisallowedFields()).map(existingFields -> new HashSet<String>(Arrays.asList(existingFields))).orElse(new HashSet());
        disallowedFields.addAll(Arrays.asList("class.*", "Class.*", "*.class.*", "*.Class.*"));
        dataBinder.setDisallowedFields(disallowedFields.toArray(new String[0]));
    }
}

