/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.okhttp;

import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class SpinnakerRequestHeaderInterceptor
implements Interceptor {
    private final OkHttpClientConfigurationProperties okHttpClientConfigurationProperties;

    public SpinnakerRequestHeaderInterceptor(OkHttpClientConfigurationProperties okHttpClientConfigurationProperties) {
        this.okHttpClientConfigurationProperties = okHttpClientConfigurationProperties;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        if (!this.okHttpClientConfigurationProperties.getPropagateSpinnakerHeaders()) {
            return chain.proceed(builder.build());
        }
        AuthenticatedRequest.getAuthenticationHeaders().forEach((key, value) -> {
            if (value.isPresent()) {
                builder.addHeader(key, (String)value.get());
            }
        });
        return chain.proceed(builder.build());
    }
}

