/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.google.common.base.Preconditions;
import com.netflix.spinnaker.okhttp.OkHttp3MetricsInterceptor;
import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import com.netflix.spinnaker.okhttp.SpinnakerRequestHeaderInterceptor;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OkHttp3ClientConfiguration
implements GroovyObject {
    private final OkHttpClientConfigurationProperties okHttpClientConfigurationProperties;
    private final OkHttp3MetricsInterceptor okHttp3MetricsInterceptor;
    private final ObjectFactory<OkHttpClient.Builder> httpClientBuilderFactory;
    private final HttpLoggingInterceptor.Level retrofit2LogLevel;
    private final SpinnakerRequestHeaderInterceptor spinnakerRequestHeaderInterceptor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Autowired
    public OkHttp3ClientConfiguration(OkHttpClientConfigurationProperties okHttpClientConfigurationProperties, OkHttp3MetricsInterceptor okHttp3MetricsInterceptor, HttpLoggingInterceptor.Level retrofit2LogLevel, SpinnakerRequestHeaderInterceptor spinnakerRequestHeaderInterceptor, ObjectFactory<OkHttpClient.Builder> httpClientBuilderFactory) {
        SpinnakerRequestHeaderInterceptor spinnakerRequestHeaderInterceptor2;
        HttpLoggingInterceptor.Level level;
        OkHttp3MetricsInterceptor okHttp3MetricsInterceptor2;
        OkHttpClientConfigurationProperties okHttpClientConfigurationProperties2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.okHttpClientConfigurationProperties = okHttpClientConfigurationProperties2 = okHttpClientConfigurationProperties;
        this.okHttp3MetricsInterceptor = okHttp3MetricsInterceptor2 = okHttp3MetricsInterceptor;
        this.retrofit2LogLevel = level = retrofit2LogLevel;
        this.spinnakerRequestHeaderInterceptor = spinnakerRequestHeaderInterceptor2 = spinnakerRequestHeaderInterceptor;
        ObjectFactory<OkHttpClient.Builder> objectFactory = httpClientBuilderFactory;
        this.httpClientBuilderFactory = objectFactory;
    }

    public OkHttp3ClientConfiguration(OkHttpClientConfigurationProperties okHttpClientConfigurationProperties, OkHttp3MetricsInterceptor okHttp3MetricsInterceptor) {
        this(okHttpClientConfigurationProperties, okHttp3MetricsInterceptor, null, null, (ObjectFactory<OkHttpClient.Builder>)((ObjectFactory)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure1(OkHttp3ClientConfiguration.class, OkHttp3ClientConfiguration.class)), ObjectFactory.class)));
    }

    public OkHttp3ClientConfiguration(OkHttpClientConfigurationProperties okHttpClientConfigurationProperties) {
        this(okHttpClientConfigurationProperties, null);
    }

    public OkHttpClient.Builder create() {
        if (this.okHttpClientConfigurationProperties.getRefreshableKeys().isEnabled()) {
            return (OkHttpClient.Builder)ScriptBytecodeAdapter.castToType((Object)this.httpClientBuilderFactory.getObject(), OkHttpClient.Builder.class);
        }
        OkHttpClient.Builder okHttpClientBuilder = this.createBasicClient();
        if (this.okHttp3MetricsInterceptor != null) {
            okHttpClientBuilder.addInterceptor((Interceptor)this.okHttp3MetricsInterceptor);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.okHttpClientConfigurationProperties.getKeyStore()) && !DefaultTypeTransformation.booleanUnbox((Object)this.okHttpClientConfigurationProperties.getTrustStore())) {
            return okHttpClientBuilder;
        }
        return this.setTruststoreKey(okHttpClientBuilder);
    }

    public OkHttpClient.Builder createForRetrofit2() {
        if (this.okHttpClientConfigurationProperties.getRefreshableKeys().isEnabled()) {
            return (OkHttpClient.Builder)ScriptBytecodeAdapter.castToType((Object)this.httpClientBuilderFactory.getObject(), OkHttpClient.Builder.class);
        }
        OkHttpClient.Builder okHttpClientBuilder = this.createBasicClient();
        if (this.spinnakerRequestHeaderInterceptor != null) {
            okHttpClientBuilder.addInterceptor((Interceptor)this.spinnakerRequestHeaderInterceptor);
        }
        if (this.okHttp3MetricsInterceptor != null) {
            okHttpClientBuilder.addInterceptor((Interceptor)this.okHttp3MetricsInterceptor);
        }
        okHttpClientBuilder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(this.retrofit2LogLevel));
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.okHttpClientConfigurationProperties.getKeyStore()) && !DefaultTypeTransformation.booleanUnbox((Object)this.okHttpClientConfigurationProperties.getTrustStore())) {
            return okHttpClientBuilder;
        }
        return this.setTruststoreKey(okHttpClientBuilder);
    }

    private OkHttpClient.Builder setTruststoreKey(OkHttpClient.Builder okHttpClientBuilder) {
        SecureRandom secureRandom;
        TrustManagerFactory trustManagerFactory;
        KeyManagerFactory keyManagerFactory;
        SSLContext sslContext;
        block5: {
            sslContext = SSLContext.getInstance("TLS");
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            Reference ks = new Reference((Object)KeyStore.getInstance(this.okHttpClientConfigurationProperties.getKeyStoreType()));
            public final class _setTruststoreKey_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference ks;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _setTruststoreKey_closure2(Object _outerInstance, Object _thisObject, Reference ks) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.ks = reference = ks;
                }

                public Object doCall(Object it) {
                    ((KeyStore)this.ks.get()).load((InputStream)ScriptBytecodeAdapter.asType((Object)it, InputStream.class), ((OkHttp3ClientConfiguration)this.getThisObject()).okHttpClientConfigurationProperties.getKeyStorePassword().toCharArray());
                    return null;
                }

                @Generated
                public Object getKs() {
                    return this.ks.get();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _setTruststoreKey_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ResourceGroovyMethods.withInputStream((File)this.okHttpClientConfigurationProperties.getKeyStore(), (Closure)new _setTruststoreKey_closure2(this, this, ks));
            keyManagerFactory.init((KeyStore)ks.get(), this.okHttpClientConfigurationProperties.getKeyStorePassword().toCharArray());
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            Reference ts = new Reference((Object)KeyStore.getInstance(this.okHttpClientConfigurationProperties.getTrustStoreType()));
            public final class _setTruststoreKey_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference ts;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _setTruststoreKey_closure3(Object _outerInstance, Object _thisObject, Reference ts) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.ts = reference = ts;
                }

                public Object doCall(Object it) {
                    ((KeyStore)this.ts.get()).load((InputStream)ScriptBytecodeAdapter.asType((Object)it, InputStream.class), ((OkHttp3ClientConfiguration)this.getThisObject()).okHttpClientConfigurationProperties.getTrustStorePassword().toCharArray());
                    return null;
                }

                @Generated
                public Object getTs() {
                    return this.ts.get();
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _setTruststoreKey_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ResourceGroovyMethods.withInputStream((File)this.okHttpClientConfigurationProperties.getTrustStore(), (Closure)new _setTruststoreKey_closure3(this, this, ts));
            trustManagerFactory.init((KeyStore)ts.get());
            secureRandom = new SecureRandom();
            try {
                SecureRandom secureRandom2;
                secureRandom = secureRandom2 = SecureRandom.getInstance(this.okHttpClientConfigurationProperties.getSecureRandomInstanceType());
            }
            catch (NoSuchAlgorithmException e) {
                Object v0;
                if (log.isErrorEnabled()) {
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.okHttpClientConfigurationProperties.getSecureRandomInstanceType()}, new String[]{"Unable to fetch secure random instance for ", ""})), (Throwable)e);
                    v0 = null;
                    break block5;
                }
                v0 = null;
            }
        }
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), secureRandom);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        Preconditions.checkState((trustManagers.length == 1 ? 1 : 0) != 0, (Object)"Found multiple trust managers; don't know which one to use");
        Preconditions.checkState((boolean)(DefaultGroovyMethods.first((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)trustManagers, Object[].class))) instanceof X509TrustManager), (String)"Configured TrustManager is a %s, not an X509TrustManager; don't know how to configure it", (Object)DefaultGroovyMethods.first((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)trustManagers, Object[].class))).getClass().getName());
        okHttpClientBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.first((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)trustManagers, Object[].class))), X509TrustManager.class));
        return this.applyConnectionSpecs(okHttpClientBuilder);
    }

    private OkHttpClient.Builder createBasicClient() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(this.okHttpClientConfigurationProperties.getMaxRequests());
        dispatcher.setMaxRequestsPerHost(this.okHttpClientConfigurationProperties.getMaxRequestsPerHost());
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().connectTimeout(this.okHttpClientConfigurationProperties.getConnectTimeoutMs(), TimeUnit.MILLISECONDS).readTimeout(this.okHttpClientConfigurationProperties.getReadTimeoutMs(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(this.okHttpClientConfigurationProperties.isRetryOnConnectionFailure()).dispatcher(dispatcher).connectionPool(new ConnectionPool(this.okHttpClientConfigurationProperties.getConnectionPool().getMaxIdleConnections(), (long)this.okHttpClientConfigurationProperties.getConnectionPool().getKeepAliveDurationMs(), TimeUnit.MILLISECONDS));
        return okHttpClientBuilder;
    }

    private OkHttpClient.Builder applyConnectionSpecs(OkHttpClient.Builder okHttpClientBuilder) {
        CallSite[] callSiteArray = OkHttp3ClientConfiguration.$getCallSiteArray();
        Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)this.okHttpClientConfigurationProperties);
        String[] cipherSuites = (String[])ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.getPropertySpreadSafe(OkHttp3ClientConfiguration.class, (Object)callSiteArray[1].call(callSiteArray[2].callGetProperty(ConnectionSpec.class)), (String)"javaName")), String[].class);
        Object object2 = callSiteArray[3].callGroovyObjectGetProperty((Object)this.okHttpClientConfigurationProperties);
        String[] tlsVersions = (String[])ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : ScriptBytecodeAdapter.getPropertySpreadSafe(OkHttp3ClientConfiguration.class, (Object)callSiteArray[4].call(callSiteArray[5].callGetProperty(ConnectionSpec.class)), (String)"javaName")), String[].class);
        Object connectionSpec = callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].callConstructor(ConnectionSpec.Builder.class, callSiteArray[10].callGetProperty(ConnectionSpec.class)), (Object)cipherSuites), (Object)tlsVersions));
        return (OkHttpClient.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call((Object)okHttpClientBuilder, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{connectionSpec, callSiteArray[12].callGetProperty(ConnectionSpec.class)}), List.class)), OkHttpClient.Builder.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != OkHttp3ClientConfiguration.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.config.OkHttp3ClientConfiguration");
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "cipherSuites";
        stringArray[1] = "cipherSuites";
        stringArray[2] = "MODERN_TLS";
        stringArray[3] = "tlsVersions";
        stringArray[4] = "tlsVersions";
        stringArray[5] = "MODERN_TLS";
        stringArray[6] = "build";
        stringArray[7] = "tlsVersions";
        stringArray[8] = "cipherSuites";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "MODERN_TLS";
        stringArray[11] = "connectionSpecs";
        stringArray[12] = "CLEARTEXT";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[13];
        OkHttp3ClientConfiguration.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(OkHttp3ClientConfiguration.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = OkHttp3ClientConfiguration.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return new OkHttpClient.Builder();
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

