/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.selector;

import com.netflix.spinnaker.kork.web.selector.SelectableService;
import com.netflix.spinnaker.kork.web.selector.ServiceSelector;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ByCloudProviderServiceSelector
implements ServiceSelector {
    private final Object service;
    private final int priority;
    private final Set<String> cloudProviders;

    public ByCloudProviderServiceSelector(Object service, Integer priority, Map<String, Object> config) {
        this.service = service;
        this.priority = priority;
        this.cloudProviders = new HashSet(((Map)config.get("cloudProviders")).values());
    }

    public Object getService() {
        return this.service;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean supports(SelectableService.Criteria criteria) {
        return this.cloudProviders.contains(criteria.getCloudProvider());
    }
}

