/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.controllers;

import com.netflix.spinnaker.kork.exceptions.HasAdditionalAttributes;
import java.util.Map;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@RestController
public class GenericErrorController
implements ErrorController {
    private final ErrorAttributes errorAttributes;

    public GenericErrorController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    @RequestMapping(value={"${server.error.path:/error}"})
    public Map error(@RequestParam(value="trace", defaultValue="false") Boolean includeStackTrace, WebRequest webRequest) {
        ErrorAttributeOptions options = includeStackTrace != false ? ErrorAttributeOptions.defaults().including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.STACK_TRACE}) : ErrorAttributeOptions.defaults();
        Map attributes = this.errorAttributes.getErrorAttributes(webRequest, options);
        Throwable exception = this.errorAttributes.getError(webRequest);
        if (exception != null && exception instanceof HasAdditionalAttributes) {
            attributes.putAll(((HasAdditionalAttributes)exception).getAdditionalAttributes());
        }
        return attributes;
    }
}

