/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config.okhttp3;

import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientBuilderProvider;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0x7FFFFFFF)
@Component
public class InsecureOkHttpClientBuilderProvider
implements OkHttpClientBuilderProvider {
    private static final Logger log = LoggerFactory.getLogger(InsecureOkHttpClientBuilderProvider.class);
    private final OkHttpClient okHttpClient;

    @Autowired
    public InsecureOkHttpClientBuilderProvider(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public Boolean supports(ServiceEndpoint service) {
        return (service.getBaseUrl().startsWith("http://") || service.getBaseUrl().startsWith("https://")) && !service.isSecure();
    }

    @Override
    public OkHttpClient.Builder get(ServiceEndpoint service) {
        OkHttpClient.Builder builder = this.okHttpClient.newBuilder();
        return this.setSSLSocketFactory(builder, service);
    }

    private OkHttpClient.Builder setSSLSocketFactory(OkHttpClient.Builder builder, ServiceEndpoint service) {
        try {
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, null);
            builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]);
            builder.hostnameVerifier((hostname, session) -> true);
        }
        catch (Exception e) {
            log.error("Unable to set ssl socket factory for {}", (Object)service.getBaseUrl(), (Object)e);
            throw new SystemException(String.format("Unable to set ssl socket factory for (%s)", service.getBaseUrl()), (Throwable)e);
        }
        return builder;
    }
}

