/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.selector.v2;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SelectableService<T> {
    private final Map<BaseUrl, T> services;
    private final T defaultService;
    private final Map<String, Object> defaultConfig;

    public SelectableService(List<BaseUrl> baseUrls, T defaultService, Map<String, Object> defaultConfig, Function<String, T> getServiceByUrlFx) {
        this.defaultService = defaultService;
        this.defaultConfig = defaultConfig;
        this.services = this.buildServices(baseUrls, getServiceByUrlFx);
    }

    public SelectedService<T> byParameters(List<Parameter> inputParameters) {
        SelectedService<T> fallback = this.getDefaultService();
        if (inputParameters == null || inputParameters.isEmpty()) {
            return fallback;
        }
        for (Map.Entry<BaseUrl, T> urlToService : this.services.entrySet()) {
            if (!inputParameters.containsAll(urlToService.getKey().parameters)) continue;
            return new SelectedService<T>(urlToService.getValue(), urlToService.getKey().getConfig(), inputParameters);
        }
        return fallback;
    }

    private Map<BaseUrl, T> buildServices(List<BaseUrl> baseUrls, Function<String, T> getServiceByUrlFx) {
        return baseUrls.stream().sorted(BaseUrl::compareTo).peek(baseUrl -> this.defaultConfig.forEach((k, v) -> baseUrl.config.putIfAbsent((String)k, v))).collect(Collectors.toMap(baseUrl -> baseUrl, baseUrl -> getServiceByUrlFx.apply(baseUrl.baseUrl), (a, b) -> b, LinkedHashMap::new));
    }

    public SelectedService<T> getDefaultService() {
        return new SelectedService<T>(this.defaultService, this.defaultConfig, null);
    }

    public Map<BaseUrl, T> getServices() {
        return this.services;
    }

    public static class SelectedService<T> {
        private final T service;
        private final Map<String, Object> config;
        private final List<Parameter> selectingParameters;

        public SelectedService(T service, Map<String, Object> config, List<Parameter> selectingParameters) {
            this.service = service;
            this.config = config;
            this.selectingParameters = selectingParameters;
        }

        public T getService() {
            return this.service;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }

        public List<Parameter> getSelectingParameters() {
            return this.selectingParameters;
        }
    }

    public static class BaseUrl
    implements Comparable {
        private String baseUrl;
        private int priority;
        private Map<String, Object> config;
        private List<Parameter> parameters;

        public Map<String, Object> getConfig() {
            return this.config;
        }

        public void setConfig(Map<String, Object> config) {
            this.config = config;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<Parameter> parameters) {
            this.parameters = parameters;
        }

        public int compareTo(Object o) {
            if (o instanceof BaseUrl) {
                BaseUrl other = (BaseUrl)o;
                if (this.priority == other.priority) {
                    return 0;
                }
                if (this.priority < other.priority) {
                    return -1;
                }
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseUrl baseUrl1 = (BaseUrl)o;
            return this.priority == baseUrl1.priority && Objects.equals(this.baseUrl, baseUrl1.baseUrl) && Objects.equals(this.config, baseUrl1.config) && Objects.equals(this.parameters, baseUrl1.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.baseUrl, this.priority, this.config, this.parameters);
        }
    }

    public static class Parameter {
        private String name;
        private List<Object> values;

        public Parameter() {
            this.values = new ArrayList<Object>();
        }

        Parameter(Map<String, Object> source) {
            this.name = source.get("name").toString();
            this.values = (List)source.get("values");
        }

        public Parameter(String name, List<Object> values) {
            this.name = name;
            this.values = values;
        }

        public Parameter withName(String name) {
            this.setName(name);
            return this;
        }

        public Parameter withValues(List<Object> values) {
            this.setValues(values);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public void setValues(List<Object> values) {
            this.values = values;
        }

        static List<Parameter> toParameters(List<Map<String, Object>> source) {
            return source.stream().map(Parameter::new).collect(Collectors.toList());
        }

        public boolean equals(Object o) {
            if (o instanceof Parameter) {
                Parameter other = (Parameter)o;
                if (!this.name.equals(other.getName())) {
                    return false;
                }
                for (Object v : this.values) {
                    if (v instanceof String && ((String)v).startsWith("regex:")) {
                        String regex = ((String)v).substring(((String)v).indexOf(":") + 1);
                        if (!other.getValues().stream().anyMatch(i -> ((String)i).matches(regex))) continue;
                        return true;
                    }
                    if (!other.getValues().stream().anyMatch(i -> i.equals(v))) continue;
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.values);
        }

        public String toString() {
            return "Parameter{name='" + this.name + "', values=" + this.values + "}";
        }
    }
}

