/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import brave.http.HttpTracing;
import brave.okhttp3.TracingInterceptor;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.OkHttpMetricsInterceptorProperties;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientCustomizer;
import com.netflix.spinnaker.kork.crypto.PasswordProvider;
import com.netflix.spinnaker.kork.crypto.SecureRandomBuilder;
import com.netflix.spinnaker.kork.crypto.StandardCrypto;
import com.netflix.spinnaker.kork.crypto.TrustStores;
import com.netflix.spinnaker.kork.crypto.X509Identity;
import com.netflix.spinnaker.kork.crypto.X509IdentitySource;
import com.netflix.spinnaker.okhttp.OkHttp3MetricsInterceptor;
import com.netflix.spinnaker.okhttp.OkHttpClientConfigurationProperties;
import com.netflix.spinnaker.okhttp.SpinnakerRequestHeaderInterceptor;
import com.netflix.spinnaker.okhttp.SpinnakerRequestInterceptor;
import com.netflix.spinnaker.retrofit.Retrofit2ConfigurationProperties;
import com.netflix.spinnaker.retrofit.RetrofitConfigurationProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.task.TaskExecutorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.support.ExecutorServiceAdapter;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OkHttpClientConfigurationProperties.class, OkHttpMetricsInterceptorProperties.class, RetrofitConfigurationProperties.class, Retrofit2ConfigurationProperties.class})
public class OkHttpClientComponents {
    private final Provider<Registry> registryProvider;
    private final OkHttpClientConfigurationProperties clientProperties;
    private final OkHttpMetricsInterceptorProperties metricsProperties;
    private final Retrofit2ConfigurationProperties retrofit2Properties;

    @Bean
    public SpinnakerRequestInterceptor spinnakerRequestInterceptor() {
        return new SpinnakerRequestInterceptor(this.clientProperties.getPropagateSpinnakerHeaders());
    }

    @Bean
    public SpinnakerRequestHeaderInterceptor spinnakerRequestHeaderInterceptor() {
        return new SpinnakerRequestHeaderInterceptor(this.clientProperties.getPropagateSpinnakerHeaders());
    }

    @Bean
    public OkHttp3MetricsInterceptor okHttp3MetricsInterceptor() {
        return new OkHttp3MetricsInterceptor(this.registryProvider, this.metricsProperties);
    }

    @Bean
    public OkHttpClientCustomizer metricsInterceptorCustomizer(OkHttp3MetricsInterceptor metricsInterceptor) {
        return builder -> builder.addInterceptor((Interceptor)metricsInterceptor);
    }

    @Bean
    public OkHttpClientCustomizer requestHeaderInterceptorCustomizer(SpinnakerRequestHeaderInterceptor headerInterceptor) {
        return builder -> builder.addInterceptor((Interceptor)headerInterceptor);
    }

    @Bean
    @ConditionalOnBean(value={HttpTracing.class})
    public OkHttpClientCustomizer tracingInterceptorCustomizer(HttpTracing httpTracing) {
        return builder -> builder.addNetworkInterceptor(TracingInterceptor.create((HttpTracing)httpTracing));
    }

    @Bean
    public Dispatcher okhttpDispatcher(TaskExecutorBuilder taskExecutorBuilder) {
        Dispatcher dispatcher = new Dispatcher((ExecutorService)new ExecutorServiceAdapter((TaskExecutor)taskExecutorBuilder.build()));
        dispatcher.setMaxRequests(this.clientProperties.getMaxRequests());
        dispatcher.setMaxRequestsPerHost(this.clientProperties.getMaxRequestsPerHost());
        return dispatcher;
    }

    @Bean
    public OkHttpClientCustomizer dispatcherCustomizer(Dispatcher dispatcher) {
        return builder -> builder.dispatcher(dispatcher);
    }

    @Bean
    public OkHttpClientCustomizer connectionPoolCustomizer() {
        OkHttpClientConfigurationProperties.ConnectionPoolProperties poolProperties = this.clientProperties.getConnectionPool();
        ConnectionPool connectionPool = new ConnectionPool(poolProperties.getMaxIdleConnections(), (long)poolProperties.getKeepAliveDurationMs(), TimeUnit.MILLISECONDS);
        return builder -> builder.connectionPool(connectionPool);
    }

    @Bean
    public OkHttpClientCustomizer connectionSpecsCustomizer() {
        List<String> tlsVersions;
        ConnectionSpec.Builder connectionSpecBuilder = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS);
        List<String> cipherSuites = this.clientProperties.getCipherSuites();
        if (!CollectionUtils.isEmpty(cipherSuites)) {
            connectionSpecBuilder.cipherSuites((String[])cipherSuites.toArray(String[]::new));
        }
        if (!CollectionUtils.isEmpty(tlsVersions = this.clientProperties.getTlsVersions())) {
            connectionSpecBuilder.tlsVersions((String[])tlsVersions.toArray(String[]::new));
        }
        ConnectionSpec tlsConnectionSpec = connectionSpecBuilder.build();
        List<ConnectionSpec> connectionSpecs = List.of(tlsConnectionSpec, ConnectionSpec.CLEARTEXT);
        return builder -> builder.connectionSpecs(connectionSpecs);
    }

    @Bean
    public OkHttpClientCustomizer sslContextCustomizer() throws IOException, GeneralSecurityException {
        SSLContext context;
        X509Identity identity = this.loadKeyStore();
        X509TrustManager trustManager = this.loadTrustStore();
        SecureRandom secureRandom = this.loadSecureRandom();
        if (identity != null) {
            context = identity.createSSLContext(trustManager, secureRandom);
        } else {
            context = StandardCrypto.getTLSContext();
            context.init(null, new TrustManager[]{trustManager}, secureRandom);
        }
        return builder -> builder.sslSocketFactory(context.getSocketFactory(), trustManager);
    }

    @Nullable
    private X509Identity loadKeyStore() {
        File keyStoreFile = this.clientProperties.getKeyStore();
        if (keyStoreFile == null) {
            return null;
        }
        PasswordProvider passwordProvider = () -> this.clientProperties.getKeyStorePassword().toCharArray();
        return X509IdentitySource.fromKeyStore((Path)keyStoreFile.toPath(), (String)this.clientProperties.getKeyStoreType(), (PasswordProvider)passwordProvider).refreshable(this.clientProperties.getRefreshableKeys().getRefreshPeriod());
    }

    private X509TrustManager loadTrustStore() throws IOException, GeneralSecurityException {
        File trustStoreFile = this.clientProperties.getTrustStore();
        if (trustStoreFile == null) {
            return TrustStores.getSystemTrustManager();
        }
        try (FileInputStream stream = new FileInputStream(trustStoreFile);){
            KeyStore truststore = KeyStore.getInstance(this.clientProperties.getTrustStoreType());
            truststore.load(stream, this.clientProperties.getTrustStorePassword().toCharArray());
            X509TrustManager x509TrustManager = TrustStores.loadTrustManager((KeyStore)truststore);
            return x509TrustManager;
        }
    }

    private SecureRandom loadSecureRandom() {
        try {
            return SecureRandom.getInstance(this.clientProperties.getSecureRandomInstanceType());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                return SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                return SecureRandomBuilder.create().withPersonalizationString("OkHttp3").build();
            }
        }
    }

    @Bean
    public OkHttpClientCustomizer connectionTimeoutsCustomizer() {
        Duration connectTimeout = Duration.ofMillis(this.clientProperties.getConnectTimeoutMs());
        Duration readTimeout = Duration.ofMillis(this.clientProperties.getReadTimeoutMs());
        boolean retryOnConnectionFailure = this.clientProperties.isRetryOnConnectionFailure();
        return builder -> builder.connectTimeout(connectTimeout).readTimeout(readTimeout).retryOnConnectionFailure(retryOnConnectionFailure);
    }

    @Bean
    public OkHttpClientCustomizer httpLoggingCustomizer() {
        return builder -> builder.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(this.retrofit2Properties.getLogLevel()));
    }

    @Bean
    @Scope(value="prototype")
    public OkHttpClient.Builder okHttpClientBuilder(ObjectProvider<OkHttpClientCustomizer> customizers) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        customizers.orderedStream().forEachOrdered(customizer -> customizer.customize(builder));
        return builder;
    }

    public OkHttpClientComponents(Provider<Registry> registryProvider, OkHttpClientConfigurationProperties clientProperties, OkHttpMetricsInterceptorProperties metricsProperties, Retrofit2ConfigurationProperties retrofit2Properties) {
        this.registryProvider = registryProvider;
        this.clientProperties = clientProperties;
        this.metricsProperties = metricsProperties;
        this.retrofit2Properties = retrofit2Properties;
    }
}

