/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.web.exceptions;

import com.netflix.spinnaker.kork.api.exceptions.ExceptionDetails;
import com.netflix.spinnaker.kork.api.exceptions.ExceptionSummary;
import com.netflix.spinnaker.kork.exceptions.HasAdditionalAttributes;
import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import com.netflix.spinnaker.kork.web.exceptions.ExceptionMessageDecorator;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;

public class ExceptionSummaryService {
    private final ExceptionMessageDecorator exceptionMessageDecorator;

    public ExceptionSummaryService(ExceptionMessageDecorator exceptionMessageDecorator) {
        this.exceptionMessageDecorator = exceptionMessageDecorator;
    }

    public ExceptionSummary summary(Throwable throwable, @Nullable ExceptionDetails exceptionDetails) {
        ArrayList<ExceptionSummary.TraceDetail> details = new ArrayList<ExceptionSummary.TraceDetail>();
        Throwable cause = throwable;
        do {
            details.add(this.createTraceDetail(cause, exceptionDetails));
        } while ((cause = cause.getCause()) != null);
        ArrayList reversedDetails = new ArrayList(details);
        Collections.reverse(reversedDetails);
        Boolean retryable = reversedDetails.stream().filter(d -> d.getRetryable() != null).findFirst().map(ExceptionSummary.TraceDetail::getRetryable).orElse(null);
        return ExceptionSummary.builder().cause(((ExceptionSummary.TraceDetail)details.get(details.size() - 1)).getMessage()).message(((ExceptionSummary.TraceDetail)details.get(0)).getMessage()).details(reversedDetails).retryable(retryable).build();
    }

    public ExceptionSummary summary(Throwable throwable) {
        return this.summary(throwable, null);
    }

    private ExceptionSummary.TraceDetail createTraceDetail(Throwable throwable, @Nullable ExceptionDetails exceptionDetails) {
        ExceptionSummary.TraceDetail.TraceDetailBuilder detailBuilder = ExceptionSummary.TraceDetail.builder().message(throwable.getMessage());
        if (throwable instanceof SpinnakerException) {
            SpinnakerException spinnakerException = (SpinnakerException)throwable;
            detailBuilder.userMessage(this.exceptionMessageDecorator.decorate(throwable, spinnakerException.getUserMessage(), exceptionDetails)).retryable(spinnakerException.getRetryable());
        }
        if (throwable instanceof HasAdditionalAttributes) {
            detailBuilder.additionalAttributes(((HasAdditionalAttributes)throwable).getAdditionalAttributes());
        }
        return detailBuilder.build();
    }
}

